#include <inttypes.h>
#include <stdint.h>
#include <math.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/vfs.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <pthread.h>
#include <time.h>
#include <sys/time.h>
#include <sys/stat.h>
#include "lamps.h"
#include "common.h"
#include "CAENVMElib.h"

struct VMEParameters   {
         uint32_t        Address[2*MAX_VME_STNS];                                                              //Address
         uint32_t        Data;                                                                                    //Data
         ushort          IRQLevel;                                                                     //Interrupt level
         unsigned char   IRQStatus;                                                                         //IRQ status
         ushort          AddressMode;                                                                  //Addressing Mode
         CVDataWidth     DataWidth;                                                                        //Data Format
         uint32_t        BaseAddress[2*MAX_VME_STNS];                                                     //Base Address
         uint32_t        BltSize;                                                           //Block size for blt (bytes)
         ushort          ncyc;                                                                        //Number of cycles
         ushort          autoinc;                                                               //Auto increment address
         uint32_t        Buff[1028];                                                            //Memory buffer for cblt
         uint16_t        McstBuff[128];                                                         //Memory buffer for mcst
         uint32_t        LLD[2*MAX_VME_STNS];                                                                      //LLD
         uint32_t        AdcGain[2*MAX_VME_STNS];                                //ADC gain for each module in the crate
         uint32_t        CBLTBaseAddress;                                          //Base Address for CBLT data transfer
         uint32_t        MCSTBaseAddress;                                          //Base Address for MCST data transfer
         uint32_t        ModuleType[2*MAX_VME_STNS];        //Type of VME module (0=Empty,1=V785 ADC, 2=V775 TDC, 3=QDC)
         ushort          VersionChoice[2*MAX_VME_STNS];   //Version of Individual Module- 32 Channel FRC/16 Channel LEMO
         uint32_t        V775TdcMode[2*MAX_VME_STNS];               //CAEN VME TDC V775 mode (common start, common stop)
         uint32_t        V775TdcFullRange[2*MAX_VME_STNS];                                      //CAEN VME TDC V775 mode
         uint32_t        V862Pedestal[2*MAX_VME_STNS];                     //CAEN VME QDC V862 Pedestal current register
         uint32_t        MTDC32WindowStart[2*MAX_VME_STNS];                 //Mesytec MTDC32 Window Start w.r.t. trigger
         uint32_t        MTDC32WindowWidth[2*MAX_VME_STNS];                                //Mesytec MTDC32 Window Width
         uint32_t        ScalerBaseAddress[2*MAX_VME_STNS];                            //Base Address for scaler modules
         uint32_t        ScalerCBLTBaseAddress;                             //Base Address for scaler CBLT data transfer
         uint32_t        ScalerGeo[2*MAX_VME_STNS];                            //Geographical address for scaler modules
         uint32_t        NoOfScalerModules;                                           //Number of scaler modules present
         int             StnIndex[2*MAX_VME_STNS];                                //Index giving original VME_STN number
         };

//Function Templates
void SAttention(gchar *Messg);
void Attention(gint XPos,gchar *Messg);
void SetStyleRecursively(GtkWidget *W,gpointer Data);
void ProcessEvent(gushort *P,gboolean Option);
void ZeroOned(gint SNo); void ZeroTwod(gint SNo);
void RefreshAll(void);
void Safety(gchar *RunName,gdouble *ElapsedTime,gint *SpecSaved);
void PeriodicLog(gint Status,gchar *RunName,glong BuffersAcquired,glong BuffersProcessed,
                 glong BytesWritten,time_t TStart,gdouble StartTime,guint32 *ScalerBuf);
void Write1d(gchar *FName,gint i,gboolean InThread);
void Write2d32(gchar *FName,gint i,gboolean InThread);
void Write2d16(gchar *FName,gint i,gboolean InThread);
void CorrectScaler(gint No);
void AbbreviateFileName(gchar *Dest,gchar *Src,gint MaxLen);
gboolean writeEventBlock(gint eventSize,gint ev_per_block,gushort data[],FILE *Fp);
void writeNames(int noOfAdcs,int noOfSingles,int noOfScalers,FILE *Fp);
void queue_text(enum blocktype block,gchar *txt,FILE *Fp);
void writeEndOfFile(FILE *Fp);
gint Read(gchar *ErrMessg); void StopNicely(void);
void fstart_(gchar *RunName,int Len); void fstop_();
void ComputeMacros(glong BuffersAcquired,FILE *MacroFp);
void ReadScalersAtEnd(gshort NScaler1,gshort *ScalerNaf);
void FileOpenNew(gchar *Title,GtkWidget *Parent,gint X,gint Y,gboolean OpenToRead,gchar *StartPath,gchar *Mask,
                 gboolean MaskEditable,void (*CallBack)(GtkWidget *,gpointer),gboolean Persist);
int SimulateRead(gushort *AcqBuf,guint32 *ScalerBuf);
void OpenRootFile(char *FName,int NPar,char [][MAX_TEXT_FIELD],char *TreeNam);
void WriteRootBlock(unsigned short *AcqBuf,int NEvt,int NPar);
void CloseRootFile(void);

//External global variables
extern gushort AcqBuf1[MAX_BUFSIZ],AcqBuf2[MAX_BUFSIZ];                                        //Two acquisition buffers
extern guint32 ScalerBuf1[MAX_SCALER],ScalerBuf2[MAX_SCALER];                           //Buffers containing Scaler data
extern guint32 ScalerCurr[MAX_SCALER],ScalerPrev[MAX_SCALER];      //Scaler values from the current and previous buffers
extern guint32 ScalerOverflows[MAX_SCALER];                                    //The number of overflows for each scaler
extern guint32 ScalerPending[MAX_SCALER];                                                    //Scaler values after Pause
extern struct Setup Setup;                                                                         //The setup variables
//extern enum V775TdcMode V775TdcMode;
extern enum ProgramState ProgramState;                                        //The current running state of the program
extern gchar RunName[120],PrevRun[120];                                           //Name of current run and previous run
extern enum AcqSignal AcqSignal;                                                                 //Stop,Pause and Resume
extern GtkWidget *S_Stat[15],*S_Scaler[4];                                                          //Status bar widgets
extern gint RefreshRate,RefreshOptimum;      //The interval (no. of buffers) for screen refreshes, RefreshOptimum=1 or 0
extern gchar SStop[120];                                            //The stop time of time of this, or the previous run
extern gint ScalerWinOpen;
extern GtkWidget **ScalerTotal,**ScalerRate,**ScalerDRate;
extern gboolean BatchRunning;
extern gfloat MacroCurr[MAX_MACRO],MacroPrev[MAX_MACRO],MacroDiff[MAX_MACRO];                //Computed values of macros
extern glong BytesWritten;
extern struct FileSelectType *FileX;
extern gchar SetupDir[MAX_DIR_STRLEN],ListFDir[MAX_DIR_STRLEN],SpecDir[MAX_DIR_STRLEN],
      BatDir[MAX_DIR_STRLEN],LogDir[MAX_DIR_STRLEN],MacroDir[MAX_DIR_STRLEN];                                //Dir prefs
extern gboolean Simulate;
extern GtkWidget *PrevWin;                               //Defined global in main.c. Used by setup.c, macro.c, control.c

//Global Variables used in this file only (except BuffersAcquired, used also in batch.c)
glong BuffersAcquired,BuffersProcessed,BufPrev,BytesPrev;                      //BuffersAcquired is also used in batch.c
gshort NPar1,NPar2;                                                                    //No. of parameters in each crate
gdouble TimePrev,StartTime,PauseDuration,PauseTime;
FILE *LogFp,*ScalerFp;                                                   //The ascii log files: lamps.log and scaler.log
time_t TStart;
unsigned long long BytesAcquired;
gint NoOfModules,BytesRecv;
gushort EvtSize;
gint NoOfSubAddr[2*MAX_VME_STNS];
gint ParaNo[32][32];                                                           //ParaNo[GeographicalAddress][SubAddress]
gint GeoAddr[MAX_PAR];
gint NoOfCAENDigitizerModule,NoOfMesytecDigitizerModule;
gint NoOfCAENParameters;       //Total no. of params in CAEN modules. Would be used to calculate no. of CBLT cycle later

struct VMEParameters VMEParameter;
struct VmeTest *VmeTest;

//Function templates
void CreateDir(void);
gint TcpConnect(gchar *EthAddr,gint EthPort);

//Function templates and global variables for threads
void *AcquireData(gpointer Data); void *BuildSpectra(void *Data);
pthread_t Acq,Spec,CntlBat,AStop;
//----------------------------------------------------------------------------------------------------------------------
CAENVME_API CAENVME_SystemReset(int32_t Handle) {}
CAENVME_API CAENVME_WriteCycle(int32_t Handle,uint32_t Address,void *Data,CVAddressModifier AM,CVDataWidth DW) {}
CAENVME_API CAENVME_ReadCycle(int32_t Handle,uint32_t Address,void *Data,CVAddressModifier AM, CVDataWidth DW) {}
CAENVME_API CAENVME_SetTimeout(int32_t Handle,CVVMETimeouts Value) {}
CAENVME_API CAENVME_GetTimeout(int32_t Handle,CVVMETimeouts *Value) {}
CAENVME_API CAENVME_BLTWriteCycle(int32_t Handle,uint32_t Address,void *Buffer,int size,CVAddressModifier AM,
   CVDataWidth DW,int *count) {}
CAENVME_API CAENVME_BLTReadCycle(int32_t Handle,uint32_t Address,void *Buffer,int Size,CVAddressModifier AM,
   CVDataWidth DW,int *count) {}
CAENVME_API CAENVME_IRQEnable(int32_t Handle,uint32_t Mask) {}
CAENVME_API CAENVME_IRQWait(int32_t Handle,uint32_t Mask,uint32_t Timeout) {}
CAENVME_API CAENVME_IRQCheck(int32_t Handle,CAEN_BYTE *Mask) {}
CAENVME_API CAENVME_IRQDisable(int32_t Handle, uint32_t Mask) {}
CAENVME_API CAENVME_IACKCycle(int32_t Handle,CVIRQLevels Level,void *Vector,CVDataWidth DW) {}
CAENVME_API CAENVME_Init(CVBoardTypes BdType,short Link,short BdNum,int32_t *Handle) {}
CAENVME_API CAENVME_End(int32_t Handle) {}
//----------------------------------------------------------------------------------------------------------------------
void InterpretVmeRet(CVErrorCodes Ret)
{
switch (Ret)
       {
       case cvSuccess   : /* g_print("Cycle completed normally\n"); */ break;
       case cvBusError  : g_print("Bus Error!\n"); break;
       case cvCommError : g_print("Communication Error!\n"); break;
       default          : g_print("Unknown Error!\n");
       }
}
//----------------------------------------------------------------------------------------------------------------------
void Pad(gchar *Str,gint N)                                          //Adds blanks to Str making it exactly N chars long
{
gint i;

for (i=strlen(Str);i<N;++i) Str[i]=' '; Str[N]='\0'; return;
}
//----------------------------------------------------------------------------------------------------------------------
void StopAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void SendStopAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void StartAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void PauseAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void ResumeAcq()
{
}
//----------------------------------------------------------------------------------------------------------------------
void CorrectScaler(gint i)                                                                     //Correction for overflow
{
if (ScalerCurr[i]<ScalerPrev[i]) { ScalerOverflows[i]++; ScalerCurr[i]+=SCALER_OVERFLOW; }
}
//----------------------------------------------------------------------------------------------------------------------
void UpdateDisplay(gdouble *ElapsedTime,gboolean Scribe,guint32 *ScalerBuf)
{
struct timeval Tv;
gdouble TimeNow,Kbps,Evtps,DelTime,DKbps,DEvtps,DeadTime;
gchar SDFree[60],SKbps[60],SEvtps[60],SBytes[60],SZSup[60],SBuffs[60],SProc[60],SElap[60],Str[255],SScaler[4][60],
      SEvts[60],SDead[60],NameF[MAX_DIR_STRLEN+20];
gulong DelBuf,DelBytes,EventsAcquired,Masters,DMasters,DEvents;
struct tm *TmStop;
time_t TStop;
struct statfs StatBuf;
gfloat DFree;
gint i;

gettimeofday(&Tv,NULL); TimeNow=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
*ElapsedTime=TimeNow-StartTime-PauseDuration;
EventsAcquired=BytesAcquired/2/Setup.Parameter.NPar;
Kbps=1.0e-03*BytesAcquired/(*ElapsedTime);
DelBuf=BuffersAcquired-BufPrev; DelTime=TimeNow-TimePrev; DelBytes=BytesAcquired-BytesPrev;
DKbps=1.e-03*DelBytes/DelTime; DEvtps=0.5*DelBytes/Setup.Parameter.NPar/DelTime;
if (RefreshOptimum) RefreshRate=(gint)MAX(2.0e03*DKbps/Setup.ListMode.BufSiz,0.1)*10;               //20 sec base value
if (Kbps>.1) sprintf(SKbps,"Kb/s: %.2f (%.2f)",Kbps,DKbps); else sprintf(SKbps,"Kb/s: %.2e (%.2e)",Kbps,DKbps);
Evtps=0.5*BytesAcquired/Setup.Parameter.NPar/(*ElapsedTime);
if (Evtps<1.0e3) sprintf(SEvtps,"Evt/s: %.2f",Evtps); else sprintf(SEvtps,"Evt/s: %.2fK",1.0e-3*Evtps);
if (DEvtps<1.0e3) sprintf(Str," (%.2f)",DEvtps); else sprintf(Str," (%.2fK)",1.0e-3*DEvtps);
strcat(SEvtps,Str);
sprintf(SElap,"Elapsed: %.1f s",*ElapsedTime);
sprintf(SBytes,"BytesAcqd.: %llu",BytesAcquired);
sprintf(SBuffs,"Buffs Acq: %ld",BuffersAcquired); sprintf(SProc,"Processed: %ld",BuffersProcessed);
sprintf(SEvts,"EventsAcq: %lu",EventsAcquired);
for (i=0;i<Setup.Scaler.NSc;++i)
   {
   ScalerPrev[i]=ScalerCurr[i];
   ScalerCurr[i]=ScalerBuf[i];
   //g_print("ScalerBuf[i=%d]=%u, ScalerCurr=%u, ScalerPrev=%u \n",i,ScalerBuf[i],ScalerCurr[i],ScalerPrev[i]);
   }
if (Setup.Scaler.Master>-1)
   {
   Masters=ScalerCurr[Setup.Scaler.Master]+ScalerPending[Setup.Scaler.Master];
   if (Masters) DeadTime=100.0*(1.0-(gdouble)EventsAcquired/(gdouble)Masters); else DeadTime=0.0;
   if (DeadTime<0.0) DeadTime=0.0;
   sprintf(SDead,"Dead  Time: %.1f%%",DeadTime);
   DMasters=ScalerCurr[Setup.Scaler.Master]-ScalerPrev[Setup.Scaler.Master];
   DEvents=0.5*DelBytes/Setup.Parameter.NPar;
   if (DMasters && (AcqSignal==Resume) && EventsAcquired)
      { sprintf(Str," (%.1f%%)",100.0*(1.0-(gdouble)DEvents/(gdouble)DMasters)); strcat(SDead,Str); }
   }
TimePrev=TimeNow; BufPrev=BuffersAcquired; BytesPrev=BytesAcquired;
if (Setup.ListMode.ListOn) sprintf(SZSup,"Z.Sup Bytes: %ld",BytesWritten);
for (i=0;i<MIN(4,Setup.Scaler.NSc);++i) sprintf(SScaler[i],"%s:%d",Setup.Scaler.Name[i],ScalerCurr[i]+ScalerPending[i]);

if (AcqSignal==Pause)
   {
   sprintf(NameF,"%s/scaler.log",LogDir); ScalerFp=fopen(NameF,"a");
   fprintf(ScalerFp,"Pause:%s Elapsed sec: %.1f\n",ctime(&TStop),*ElapsedTime);
   fclose(ScalerFp);
   }

if (Scribe)
   {
   TStop=time(NULL); TmStop=localtime(&TStop);
   sprintf(SStop,"Stop: %02d:%02d:%02d",TmStop->tm_hour,TmStop->tm_min,TmStop->tm_sec);
   sprintf(NameF,"%s/lamps.log",LogDir);
   if ((LogFp=fopen(NameF,"a"))==NULL)                                        //Open log file and make the final entries
      {
      SAttention("Couldnt open log file lamps.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   strcpy(Str,ctime(&TStop)); Str[24]='\0'; Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Stop:",Str);
   sprintf(Str,"%.1f",*ElapsedTime);        Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Elapsed sec:",Str);
   sprintf(Str,"%ld",BuffersAcquired);      Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Buffers Acquired:",Str);
   sprintf(Str,"%ld",BuffersProcessed);     Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Buffers Processed:",Str);
   sprintf(Str,"%ld",EventsAcquired);       Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Events:",Str);
   sprintf(Str,"%.2f",Evtps);               Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Evt/s:",Str);
   if (Setup.Scaler.Master>-1) sprintf(Str,"%.1f%%",DeadTime); else sprintf(Str,"-");
                                            Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Dead Time:",Str);
   if (Setup.ListMode.ListOn) sprintf(Str,"%ld",BytesWritten); else sprintf(Str,"No list");
                                            Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","List Bytes:",Str);
   for (i=0;i<4;i++)                  //We always write only 4 scaler values here. All scalers are written to scaler.log
       {
       if (i<=Setup.Scaler.NSc) sprintf(Str,"%d",ScalerCurr[i]+ScalerPending[i]); else sprintf(Str,"0");
       Pad(Str,30); fprintf(LogFp,"%-6s%02d: %13s %s}\n","Scaler",i+1," ",Str);
       }
   fprintf(LogFp,"-------------------------------------------------------\n");
   fclose(LogFp);

   sprintf(NameF,"%s/scaler.log",LogDir);
   if ((ScalerFp=fopen(NameF,"a"))==NULL)                              //Open scaler log file and make the final entries
      {
      SAttention("Couldnt open log file scaler.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   if (AcqSignal==Stop) fprintf(ScalerFp,"Stop: %s Elapsed sec: %.1f\n",ctime(&TStop),*ElapsedTime);
   for (i=0;i<Setup.Scaler.NSc;++i)
       fprintf(ScalerFp,"Scaler%02d %s %d\n",i+1,Setup.Scaler.Name[i],ScalerCurr[i]+ScalerPending[i]);
   fprintf(ScalerFp,"-------------------------------------------------------\n");
   fclose(ScalerFp);
   }

gdk_threads_enter();
gtk_label_set_text(GTK_LABEL(S_Stat[ 9]),SKbps);
gtk_label_set_text(GTK_LABEL(S_Stat[10]),SEvtps);
gtk_label_set_text(GTK_LABEL(S_Stat[11]),SBytes);
gtk_label_set_text(GTK_LABEL(S_Stat[13]),SEvts);
if (Setup.Scaler.Master>-1) gtk_label_set_text(GTK_LABEL(S_Stat[14]),SDead);
if (Setup.ListMode.ListOn)
   {
   statfs("./",&StatBuf);
   DFree=(gfloat)StatBuf.f_bavail*StatBuf.f_bsize/1024.0/1024.0/1024.0; sprintf(SDFree,"Free: %-3.3fGb",DFree);
   if (DFree<1.0) { DFree=1024.0*DFree; sprintf(SDFree,"Free: %-3.1fMb",DFree); }
   if (DFree<1.0) { DFree=1024.0*DFree; sprintf(SDFree,"Free: %-3.1fKb",DFree); }
   gtk_label_set_text(GTK_LABEL(S_Stat[2]),SDFree);                                                 //Free space on disk
   gtk_label_set_text(GTK_LABEL(S_Stat[12]),SZSup);                                                        //Z.Sup Bytes
   }
gtk_label_set_text(GTK_LABEL(S_Stat[ 7]),SBuffs);
gtk_label_set_text(GTK_LABEL(S_Stat[ 8]),SProc);
gtk_label_set_text(GTK_LABEL(S_Stat[ 5]),SElap);
for (i=0;i<MIN(4,Setup.Scaler.NSc);i++) gtk_label_set_text(GTK_LABEL(S_Scaler[i]),SScaler[i]);
if (AcqSignal == Stop)
   { gtk_label_set_text(GTK_LABEL(S_Stat[6]),SStop); gtk_label_set_text(GTK_LABEL(S_Stat[0]),"Status: Free"); }
if (BatchRunning)
   { sprintf(Str,"Batch: %d/%d",Setup.BatAcq.Current,Setup.BatAcq.NBat); gtk_label_set_text(GTK_LABEL(S_Stat[0]),Str); }
RefreshAll();
if (ScalerWinOpen)
   {
   for (i=0;i<Setup.Scaler.NSc;++i)
       {
       sprintf(Str,"%d",ScalerCurr[i]+ScalerPending[i]);
       gtk_label_set_text(GTK_LABEL(GTK_BIN(ScalerTotal[i])->child),Str);
       if (*ElapsedTime>0.5) sprintf(Str,"%.1f",(gdouble)(ScalerCurr[i]+ScalerPending[i])/(*ElapsedTime));
       gtk_label_set_text(GTK_LABEL(GTK_BIN(ScalerRate[i])->child),Str);
       if (*ElapsedTime>0.5) sprintf(Str,"%.1f",(gdouble)(ScalerCurr[i]-ScalerPrev[i])*RefreshRate/DelTime);
       gtk_label_set_text(GTK_LABEL(GTK_BIN(ScalerDRate[i])->child),Str);
       }
   }
gdk_threads_leave();
}
//----------------------------------------------------------------------------------------------------------------------
void ZlsError(void)
{
SAttention("Error: Disk Full...Acq Stopped!");
StopNicely();
}
//----------------------------------------------------------------------------------------------------------------------
gboolean CheckLGates(gushort *Par)                                                              //Checks list mode gates
{
gint i;

for (i=0;i<Setup.ListMode.NoOfLGates;++i)
    {
    if ((Par[Setup.ListMode.LGates[i].Para-1] < Setup.ListMode.LGates[i].Lo) ||
        (Par[Setup.ListMode.LGates[i].Para-1] > Setup.ListMode.LGates[i].Hi)) return FALSE;
    }
return TRUE;
}
//----------------------------------------------------------------------------------------------------------------------
gint CompressToDisk(FILE *Fp,gushort *AcqBuf)                              //zls, candle and csv formats are implemented
{
gint i,j,k,l,m,NEvt,Ptr1,Ptr2,CPtr,CBufSiz,HdrWds;
gushort Par[MAX_PAR];
gushort CompBuf[2*MAX_BUFSIZ];                            //The compressed buffer can be larger than AcqBuf[65536 words]
gushort BitMask[MAX_HDR];                                              //The event masks, 1 mask for every 16 parameters
static gchar Sign[4] = {"DAPS"};
gshort Code;
gboolean AcceptEvent;                               //If all parameters are outside [LLD,ULD] we reject the entire event

NEvt=Setup.ListMode.BufSiz/2/Setup.Parameter.NPar;                                                    //Number of events
switch (Setup.ListMode.Compr)                                                           //zls=1; ROOT=2; candle=0; csv=3
   {
   case 0:                                   //IUAC Freedom format. Here CompBuf is used to hold the crate combined data
           for (i=0,Ptr1=0,Ptr2=BytesRecv/2,CPtr=0;i<NEvt;++i)
               {
               for (j=0;j<NPar1;++j) CompBuf[CPtr+j]=AcqBuf[Ptr1+j];
               CPtr+=NPar1;
               for (j=0;j<NPar2;++j) CompBuf[CPtr+j]=AcqBuf[Ptr2+j];
               CPtr+=NPar2;
               Ptr1+=NPar1; Ptr2+=NPar2;
               }
           if (!writeEventBlock(Setup.Parameter.NPar,NEvt,CompBuf,Fp)) { ZlsError(); return FALSE; }
           break;
   case 1:                                                                                           //Normal zls format
           HdrWds=(Setup.Parameter.NPar+15)/16;
           for (i=0,Ptr1=0,Ptr2=BytesRecv/2,CPtr=0,AcceptEvent=FALSE;i<NEvt;++i)            //Loop over events in AcqBuf
               {
               for (j=0;j<HdrWds;++j) BitMask[j]=0;
               for (j=0,m=0;j<Setup.Parameter.NPar;++j)
                   {
                   k=j/16; l=j%16;
                   if (j<NPar1) Par[j]=AcqBuf[Ptr1+j]; else Par[j]=AcqBuf[Ptr2+j-NPar1];
                   if ((Par[j] >= Setup.Parameter.LLD[j]) && (Par[j] <= Setup.Parameter.ULD[j]))
                      { AcceptEvent=TRUE; BitMask[k]|=1<<l; CompBuf[CPtr+HdrWds+m]=Par[j]; m++; }
                   }
               if (Setup.ListMode.NoOfLGates) if (!CheckLGates(Par)) AcceptEvent=FALSE;                //Gated List Mode
               if (AcceptEvent)
                  {
                  for (j=0;j<HdrWds;++j) CompBuf[CPtr+j]=BitMask[j];
                  CPtr+=HdrWds+m;
                  }
               Ptr1+=NPar1; Ptr2+=NPar2;
               }
           CBufSiz=2*CPtr;
           if (fwrite(Sign,4,1,Fp)<1) { ZlsError(); return FALSE; }
           if (fwrite(&CBufSiz,4,1,Fp)<1) { ZlsError(); return FALSE; }
           if (fwrite(CompBuf,2,CPtr,Fp)<CPtr) { ZlsError(); return FALSE; }
           BytesWritten+=(8+2*CPtr);
           break;
   case 2: break;                                               //Code wont reach here. ROOT format is handled elsewhere
   case 3:                                                                                            //Excel csv format
           for (i=0,Ptr1=0,Ptr2=BytesRecv/2,AcceptEvent=FALSE;i<NEvt;++i)
              {
              for (j=0;j<Setup.Parameter.NPar;++j)
                 {
                 if (j<NPar1) Par[j]=AcqBuf[Ptr1+j]; else Par[j]=AcqBuf[Ptr2+j-NPar1];
                 if ((Par[j] >= Setup.Parameter.LLD[j]) && (Par[j] <= Setup.Parameter.ULD[j])) AcceptEvent=TRUE;
                 }
              if (AcceptEvent)
                 {
                 for (j=0;j<Setup.Parameter.NPar;++j)
                     {
                     if (j<Setup.Parameter.NPar-1) fprintf(Fp,"%d,",Par[j]);
                     else fprintf(Fp,"%d\n",Par[j]);
                     }
                 }
                 Ptr1+=NPar1; Ptr2+=NPar2;
              }
   }
return TRUE;
}
//----------------------------------------------------------------------------------------------------------------------
void *BuildSpectra(void *Data)
{
gushort *AcqBuf;
gushort Para[MAX_TOTAL_PAR];
gint Evt,i,Ptr1,EventsPerBuf;

EventsPerBuf=BytesRecv/2/Setup.Parameter.NPar; AcqBuf=(gushort *)Data;
//for (i=0;i<BytesRecv/2;++i) {if (((i==3) || (i==35))&& (AcqBuf[i]!=0))  g_print("i=%d, Data=%d\n",i, AcqBuf[i]);}
for (Evt=0,Ptr1=0;Evt<EventsPerBuf;Evt++)
    {
    for (i=0;i<Setup.Parameter.NPar;++i) {Para[i]=AcqBuf[Ptr1+i];}
    ProcessEvent(Para,FALSE); Ptr1+=Setup.Parameter.NPar;
    //for (i=0;i<Setup.Parameter.NPar;++i) {if (Para[i]==24064) g_print("Para[%d]=%d\n",i, Para[i]);}
    }
BuffersProcessed++;
//g_print("End of build Spectra...BuffersProcessed=%ld\n",BuffersProcessed);
pthread_exit(NULL);
return NULL;
}
//----------------------------------------------------------------------------------------------------------------------
void *ControlAutoStop(gpointer Unused)
{ sleep(Setup.Hardware.AutoStop); StopNicely(); pthread_exit(NULL); return NULL;}
//----------------------------------------------------------------------------------------------------------------------
void ReadScalersAtEnd(gshort NScaler1,gshort *ScalerNaf)
{
}
//----------------------------------------------------------------------------------------------------------------------
void VMEInit(int32_t BHandle)
{
guint32 Offset,DataWidth,BaseAddr,Data,Geo;
const gchar *OffsetHex,*AddressWidth,*BaseAddrHex;
gint Id,i,j,k,m,kstart,MaxNoOfSubAddr,l,x;
guint32 LLD[2*MAX_VME_STNS];
guint32 V830ChannelEnableRegister,NoOfChannelInV830[2*MAX_VME_STNS],CumilativeScalerSubAddress;
CVErrorCodes    Ret;

CAENVME_SystemReset(BHandle);
Offset=0x0000;
kstart=0;
//g_print("Offset=0x%X\n",Offset);
for (i=0,j=0;i<2*MAX_VME_STNS;i++)
   {
   if (Setup.Hardware.Modules[i]!=0)                //Creating a database of non-empty stations and their (Base) Address
      {
                VMEParameter.StnIndex[j]=i;
      BaseAddrHex=Setup.Hardware.Properties[i].BaseAddr;
      VMEParameter.BaseAddress[j]=strtoul(BaseAddrHex,NULL,16);
      VMEParameter.Address[j]=VMEParameter.BaseAddress[j]+Offset;
      VMEParameter.LLD[j]=Setup.Hardware.Properties[i].AdcLLD;
      VMEParameter.ModuleType[j]=Setup.Hardware.Modules[i];
      if (VMEParameter.ModuleType[j]==2)
         {
         VMEParameter.V775TdcMode[j]=Setup.Hardware.Properties[i].V775TdcMode;
         VMEParameter.V775TdcFullRange[j]=Setup.Hardware.Properties[i].V775TdcFullRange;
         /*g_print("Stn No=%d, Base Address=0x%X, VMEParameter.V775TdcMode=%d, VMEParameter.V775TdcFullRange=%d\n",
                   i+1,VMEParameter.BaseAddress[j],VMEParameter.V775TdcMode[j],VMEParameter.V775TdcFullRange[j]);*/
         }
      if (VMEParameter.ModuleType[j]==3)
        {
         VMEParameter.V862Pedestal[j]=Setup.Hardware.Properties[i].V862Pedestal;
         /*g_print("Stn No=%d, Base Address=0x%X, VMEParameter.V862Pedestal=%d\n",i+1,VMEParameter.BaseAddress[j],
                    VMEParameter.V862Pedestal[j]);*/
         }
        /*g_print("Stn No=%d, Base Address=0x%X, LLD=%d, ModuleType=%d \n",i+1,VMEParameter.BaseAddress[j],
                   VMEParameter.LLD[j],VMEParameter.ModuleType[j]);*/
      for (k=kstart;k<NPar1;++k)
         {
         if (Setup.Parameter.N[k]==Setup.Parameter.N[kstart])
            { Setup.Parameter.BaseAddr[k]=VMEParameter.BaseAddress[j]; if (k==NPar1-1) NoOfSubAddr[j]=NPar1-kstart; }
         else
            {
            NoOfSubAddr[j]=k-kstart;
            kstart=k; break;
            }
         }
      j++;
      }
   NoOfModules=j;
   }
/*for (i=0;i<NPar1;++i)
g_print("Parameter No=%d,Setup.Parameter.A=%d,Setup.Parameter.N=%d,Setup.Parameter.BaseAddr=0x%08X\n",i+1,
         Setup.Parameter.A[i],Setup.Parameter.N[i], Setup.Parameter.BaseAddr[i]);*/

/*We want to find the No Of Scaler Modules, First Scaler Module, Last Scaler Module, Intermediate Scaler Modules and
then set them CBLT, GEO address and other initialization*/
if (Setup.Scaler.NSc>0)                                                            //Check whether a scalar is present ?
   {
   VMEParameter.NoOfScalerModules=1;
   VMEParameter.ScalerBaseAddress[0]=Setup.Scaler.BaseAddr[0];
   VMEParameter.ScalerGeo[0]=Setup.Scaler.N[0];
   /*g_print("Setup.Scaler.N[0]=%d, Setup.Scaler.A=%d, Setup.Scaler.BaseAddr=0x%8X\n",
              Setup.Scaler.N[0],Setup.Scaler.A[0],Setup.Scaler.BaseAddr[0]);*/
   for (i=1,j=0;i<Setup.Scaler.NSc;i++)
      {
      NoOfChannelInV830[j]=0;
      if (Setup.Scaler.N[i]!=Setup.Scaler.N[i-1]) {VMEParameter.NoOfScalerModules++;j++;}
      VMEParameter.ScalerBaseAddress[j]=Setup.Scaler.BaseAddr[i];
      VMEParameter.ScalerGeo[j]=Setup.Scaler.N[i];
      /*g_print("Setup.Scaler.N[%d]=%d, Setup.Scaler.A=%d, Setup.Scaler.BaseAddr=0x%8X\n",i,Setup.Scaler.N[i],
                 Setup.Scaler.A[i],Setup.Scaler.BaseAddr[i]);*/
      }
   if (Setup.Scaler.NSc==1) NoOfChannelInV830[0]=0;                                                //Only initialization
   //g_print("NoOfChannelInV830[j=%d]=0x%8X\n",j,NoOfChannelInV830[j]);
   for (i=1,j=0;i<Setup.Scaler.NSc;i++)
      {
      NoOfChannelInV830[j]++;
      if (Setup.Scaler.N[i]!=Setup.Scaler.N[i-1]) j++;
      }
   NoOfChannelInV830[VMEParameter.NoOfScalerModules-1]++;
   CumilativeScalerSubAddress=0;
   for (j=0;j<VMEParameter.NoOfScalerModules;j++)
      {
      //g_print("NoOfChannelInV830[j=%d]=0x%8X\n",j,NoOfChannelInV830[j]);
      V830ChannelEnableRegister=0;
      for (k=CumilativeScalerSubAddress;k<(CumilativeScalerSubAddress+NoOfChannelInV830[j]);k++)
         {
         V830ChannelEnableRegister+=(1<<Setup.Scaler.A[k]);
         }
      CumilativeScalerSubAddress=CumilativeScalerSubAddress+NoOfChannelInV830[j];
      /*g_print("CumilativeScalerSubAddress=%d\n",CumilativeScalerSubAddress);
        CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1100,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, CBLT Base Address=0x%02X before setup\n",j+1, Data&0xFF);*/

      //Writing the bit pattern in Channel Enable Register for enabling individual channel as per Set up file
      Data=V830ChannelEnableRegister;
      //g_print("V830ChannelEnableRegister=0x%8X\n",V830ChannelEnableRegister);
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1100,&Data,cvA32_U_DATA,cvD32);
      }
   for (j=0;j<VMEParameter.NoOfScalerModules;j++)
      {
      Geo=VMEParameter.ScalerGeo[j]; 
      //g_print("VMEParameter.NoOfScalerModules=%u, Geo= %u\n",VMEParameter.NoOfScalerModules,Geo);
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1110,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, Geo Address=0x%02X before software reset\n",j+1, Data&0x1F);*/
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1110,&Geo,cvA32_U_DATA,cvD16);
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1110,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, Geo Address=0x%02X after software reset\n",j+1, Data&0x1F);*/
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111E,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, CBLT Control Register=0x%01X before setup\n",j+1, Data&0x3);*/
      if (j==0) Data=0x2;                                                                                 //First module
      else if (j==VMEParameter.NoOfScalerModules-1) Data=0x1;                                              //Last module
      else Data=0x3;                                                                               //Intermediate module
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111E,&Data,cvA32_U_DATA,cvD16);
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111E,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, CBLT Control Register=0x%01X after setup\n",j+1, Data&0x3);*/
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111C,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, CBLT Base Address=0x%02X before setup\n",j+1, Data&0xFF);*/
      Data=0x00CC; VMEParameter.ScalerCBLTBaseAddress=(Data&0xFF)<<24;
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111C,&Data,cvA32_U_DATA,cvD16);
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111C,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, CBLT Base Address=0x%02X after setup\n",j+1, Data&0xFF);*/
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1108,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, V830 Control Register=0x%02X before setup\n",j+1, Data&0xFF);*/
      if (j==VMEParameter.NoOfScalerModules-1) Data=0x0031;                              //Enabling bus error and Header
                                         //Will work only with CAEN V830 Scaler - Also Clears MEB, Counter Registers etc
      else Data=0x0021;                                                                           //Enabling only Header
                                         //Will work only with CAEN V830 Scaler - Also Clears MEB, Counter Registers etc
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1108,&Data,cvA32_U_DATA,cvD16);
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1108,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, V830 Control Register=0x%02X after setup\n",j+1, Data&0xFF);*/
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1130,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, V830 BLT Evt no reg.=0x%02X before setup\n",j+1, Data&0xFF);*/
      Data=0x01;                                                                  //With Data=1-BLT reads only one event
                                    //Data=Any other value-BLT reads the requested number of bytes(VMEParameter.BltSize)
                                                                                  //Will work only with CAEN V830 Scaler
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1130,&Data,cvA32_U_DATA,cvD16);
                                            //Setting BLT Event number register - Also Clears MEB, Counter Registers etc
      /*CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1130,&Data,cvA32_U_DATA,cvD16);
        g_print("Module no=%d, V830 BLT Evt no reg.=0x%02X after setup\n",j+1, Data&0xFF);*/
      }
   }

x=0;
Geo=1;
for (j=0;j<NoOfModules;j++)
   {
   //g_print("VMEParameter.ModuleType[j=%d]=%d NoOfModules=%d\n",j,VMEParameter.ModuleType[j],NoOfModules);
   if ((VMEParameter.ModuleType[j]==1)||(VMEParameter.ModuleType[j]==2)||(VMEParameter.ModuleType[j]==3))
                                                                                                 //Only for CAEN modules
      {
      // ......Setting up Geographical Adddress for all modules before acquisition starts ......
      /*CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1002,&Data,cvA32_U_DATA,2);
        g_print("Module no=%d, Geo Address=0x%04X before software reset\n",j+1, Data&0xFFFF);*/
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1002,&Geo,cvA32_U_DATA,2);
      /*CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1002,&Data,cvA32_U_DATA,2);
        g_print("Module no=%d, Geo Address=0x%04X after software reset\n",j+1, Data&0xFFFF);*/
      Geo=Geo+1;
      // ......Reset (software) all the modules before acquisition starts ......
      /*CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
        g_print("Module no=%d, Bit Set 1=0x%04X before software reset\n",j+1, Data&0xFFFF);*/
      Data=0x0080;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
      /*CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
        g_print("Module no=%d, Bit Set 1=0x%04X after software reset\n",j+1, Data&0xFFFF);*/
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1008,&Data,cvA32_U_DATA,2);
      /*CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
        g_print("Module no=%d, Bit Set 1=0x%04X after Bit Clear 1\n",j+1, Data&0xFFFF);*/
      // Software reset complete..........Setting up LLD.............
      if (VMEParameter.LLD[j]>=510)
         {
         LLD[j]=VMEParameter.LLD[j]/16;
         Data=0x0100;                                                            //Clearing Bit9 in bit clear 2 register
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1034,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         }
      else
         {
         LLD[j]=VMEParameter.LLD[j]/2;
         Data=0x0100;                                              //Setting bit set 2 register for STEP_TH =x2 (Bit8=1)
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         }
      Offset=0x1080;
      l=0;
      for (i=0;i<NoOfSubAddr[j];++i)
         {
         if (l==Setup.Parameter.A[x+i])
            {
            Data=LLD[j]; Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            InterpretVmeRet(Ret);                                                        //Setting LLD for used channels
            /*Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
              g_print("In if loop...Used Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                       i,Setup.Parameter.A[x+i],Data,Offset);*/
            Offset=Offset+2;++l;
            }
         else if (l<Setup.Parameter.A[x+i])                    //Setting kill bit in LLD register to disable the channel
            {
            for (k=l;k<Setup.Parameter.A[x+i];++l,++k)
               {
               Data=0x0100;
               Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               InterpretVmeRet(Ret);
               /*Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               g_print("In else loop with kill bit...Unused Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                        k,Setup.Parameter.A[x+i],Data,Offset);*/
               Offset=Offset+2;
            }
            Data=LLD[j];
            Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            InterpretVmeRet(Ret);
            //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            /*g_print("In else loop with LLD value...Used Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                       k,Setup.Parameter.A[x+i],Data,Offset);*/
            Offset=Offset+2;++l;
            }
         }
         if (Setup.Parameter.A[x+NoOfSubAddr[j]-1]!=31)
            {
            for (m=Setup.Parameter.A[x+NoOfSubAddr[j]-1]+1;m<32;++m)
               {
               Data=0x0100;Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               InterpretVmeRet(Ret);
               //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               /*g_print("Enabling kill bit for Sub-addresses upto 31...Unused Sub-Address=%d,Data=%d,Offset=0x%04X\n",
                          m,Data,Offset);*/
               Offset=Offset+2;
               }
            }
         x=x+NoOfSubAddr[j];
         // .......... LLD setup complete .................setting event counter ...............
         Data=0x4000;                                                             //To clear bit15 in bit set 2 register
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1034,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
         //if (!(Data&0x4000)) g_print("Mode set to increment event counter only on accepted triggers\n");
         Data=1<<3;                                                                        //Overrange checking disabled
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         Data=0xFF;                           //Dummy write with any data to 0x1040 is sufficient to reset event counter
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1040,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
         Data=Data|0x1000;       //Setting Emty Prog bit of Bit Set 2 register to write and EOB even if there is no data
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
      }
   }
for (j=0;j<NoOfModules;j++)                                                                        //CAEN V775 TDC setup
   {
   if ((VMEParameter.ModuleType[j]==2))
      {
      //g_print("VMEParameter.ModuleType[%d]=%d\n",j, VMEParameter.ModuleType[j]);
      Data=1<<10;
      if (VMEParameter.V775TdcMode[j]==0) Offset=0x1034;                                                  //Common Start
      else Offset=0x1032;                                                                                  //Common Stop
      //g_print("VMEParameter.V775TdcMode=%d\n",VMEParameter.V775TdcMode[j]);
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
      //g_print ("Offset=0x%4X, Data=0x%4X\n",Offset,Data);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
      InterpretVmeRet(Ret);
      if (VMEParameter.V775TdcFullRange[j]==1200)     Data=31;
      else if (VMEParameter.V775TdcFullRange[j]==1100) Data=35;
      else if (VMEParameter.V775TdcFullRange[j]==1000) Data=39;
      else if (VMEParameter.V775TdcFullRange[j]==900)  Data=44;
      else if (VMEParameter.V775TdcFullRange[j]==800)  Data=50;
      else if (VMEParameter.V775TdcFullRange[j]==700)  Data=58;
      else if (VMEParameter.V775TdcFullRange[j]==600)  Data=68;
      else if (VMEParameter.V775TdcFullRange[j]==500)  Data=82;
      else if (VMEParameter.V775TdcFullRange[j]==400)  Data=103;
      else if (VMEParameter.V775TdcFullRange[j]==300)  Data=139;
      else if (VMEParameter.V775TdcFullRange[j]==200)  Data=215;
      else                                             Data=255;
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1060,&Data,cvA32_U_DATA,2);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1060,&Data,cvA32_U_DATA,2);
      //g_print ("Data after V775TdcFullRange setting=0x%4X\n",Data);
      InterpretVmeRet(Ret);                                                                       //TDC Full range setup
      }
   }
//....Setting up Iped register of CAEN VME QDC V862 for pedestal correction
for (j=0;j<NoOfModules;j++)                                                                        //CAEN V775 TDC setup      
   {
   if ((VMEParameter.ModuleType[j]==3))
      {
      //g_print("VMEParameter.ModuleType[%d]=%d\n",j, VMEParameter.ModuleType[j]);
      Data=VMEParameter.V862Pedestal[j];
      Offset=0x1060;
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
      //g_print ("Pedestal set as =%d \n",Data);
      InterpretVmeRet(Ret);
      }
   }
for (j=0;j<NoOfModules;j++)                                     //Reset (data) all the modules before acquisition starts
   {
   if ((VMEParameter.ModuleType[j]==1)||(VMEParameter.ModuleType[j]==2)||(VMEParameter.ModuleType[j]==3))    //Only CAEN
      {
      //..................Data Reset starts from here.........
      Data=0x4;
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
      InterpretVmeRet(Ret);
      //g_print("Bit Set 2=0x%04X after data reset\n",Data&0xFFFF);
      Data=0x4;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1034,&Data,cvA32_U_DATA,2);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
      //g_print("Bit Set 2=0x%04X after Bit Clear 2\n",Data&0xFFFF);
      //.....................Data Reset completed.............
      }
   }
if (Setup.Scaler.NSc>0)                                                              //Check whether a scalar is present
   {
   for (j=0;j<VMEParameter.NoOfScalerModules;j++)
      {
      Data=0xFFFF;                                           //V830 scaler Data Reset. Clears MEB, Counter Registers etc
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1122,&Data,cvA32_U_DATA,cvD16);
      }
   }
VMEParameter.AddressMode=cvA32_U_DATA;
DataWidth=4; VMEParameter.DataWidth=DataWidth; //g_print("Data width=%u\n",DataWidth*8);
EvtSize=NPar1; //NoOfModules*32;
}
//----------------------------------------------------------------------------------------------------------------------
void VMEInitCBLT(int32_t BHandle)
{
guint32 Offset,DataWidth,BaseAddr,Data,Geo,BytesRead;
float TdcResolution;
const gchar *OffsetHex,*AddressWidth,*BaseAddrHex;
gint Id,i,j,k,m,kstart,MaxNoOfSubAddr,l,x,CumSubAddr,CAENDigitizerModule,MesytecDigitizerModule;
guint32 LLD[2*MAX_VME_STNS];
guint32 V830ChannelEnableRegister,NoOfChannelInV830[2*MAX_VME_STNS],CumilativeScalerSubAddress;
CVErrorCodes    Ret;
gboolean FirstMesytecModule,FirstCAENModule;
enum CVVMETimeouts TimeoutValue;

CAENVME_SystemReset(BHandle);                               //This will also disable the master gate from IO module v977

//CAENVME_SetTimeout(BHandle,cvTimeout400us); 
//BUS TIMOUT increased to 400us (instead of 50us). This allows CBLT >256 read cycles
CAENVME_SetTimeout(BHandle,cvTimeout50us);
CAENVME_GetTimeout(BHandle,&TimeoutValue);
printf("This is multichain version (each chain <256 cycles) TimeoutValue=%d\n",TimeoutValue);

NoOfCAENDigitizerModule=0; NoOfMesytecDigitizerModule=0;
Offset=0x0000;
kstart=0;
//g_print("Offset=0x%X\n",Offset);
for (i=0,j=0;i<2*MAX_VME_STNS;i++)
   {
   if (Setup.Hardware.Modules[i]!=0)                //Creating a database of non-empty stations and their (Base) Address
      {
      VMEParameter.StnIndex[j]=i;
      //g_print("Here j=%d i=%d StnIndex=%d\n",j,i,VMEParameter.StnIndex[j]);
      BaseAddrHex=Setup.Hardware.Properties[i].BaseAddr;
      VMEParameter.BaseAddress[j]=strtoul(BaseAddrHex,NULL,16);
      VMEParameter.Address[j]=VMEParameter.BaseAddress[j]+Offset;
      VMEParameter.LLD[j]=Setup.Hardware.Properties[i].AdcLLD;
      VMEParameter.AdcGain[j]=Setup.Hardware.Properties[i].AdcGain;
      VMEParameter.ModuleType[j]=Setup.Hardware.Modules[i];
      VMEParameter.VersionChoice[j]=Setup.Hardware.VersionChoice[i];
      if ((VMEParameter.ModuleType[j]==1)||(VMEParameter.ModuleType[j]==2)||(VMEParameter.ModuleType[j]==3))
         NoOfCAENDigitizerModule++;                                                    //Counting CAEN digitizer modules
      if ((VMEParameter.ModuleType[j]==4)||(VMEParameter.ModuleType[j]==5))
         NoOfMesytecDigitizerModule++;                                            //Counting Mesytec ADC and TDC modules
      if (VMEParameter.ModuleType[j]==2)
         {
         VMEParameter.V775TdcMode[j]=Setup.Hardware.Properties[i].V775TdcMode;
         VMEParameter.V775TdcFullRange[j]=Setup.Hardware.Properties[i].V775TdcFullRange;
         /*g_print("Stn No=%d, Base Address=0x%X, VMEParameter.V775TdcMode=%d, VMEParameter.V775TdcFullRange=%d\n",
                   i+1,VMEParameter.BaseAddress[j],VMEParameter.V775TdcMode[j],VMEParameter.V775TdcFullRange[j]);*/
         }
      if (VMEParameter.ModuleType[j]==3)
         {
         VMEParameter.V862Pedestal[j]=Setup.Hardware.Properties[i].V862Pedestal;
         /*g_print("Stn No=%d, Base Address=0x%X, VMEParameter.V862Pedestal=%d\n",i+1,
                    VMEParameter.BaseAddress[j],VMEParameter.V862Pedestal[j]);*/
         }
      if (VMEParameter.ModuleType[j]==5)
         {
         VMEParameter.MTDC32WindowStart[j]=Setup.Hardware.Properties[i].MTDC32WindowStart;
         VMEParameter.MTDC32WindowWidth[j]=Setup.Hardware.Properties[i].MTDC32WindowWidth;
         }
      /*g_print("Stn No=%d, Base Address=0x%X, LLD=%d, ModuleType=%d\n",i+1,
                VMEParameter.BaseAddress[j],VMEParameter.LLD[j],VMEParameter.ModuleType[j]);*/
      for (k=kstart;k<NPar1;++k)
         {
         if (Setup.Parameter.N[k]==Setup.Parameter.N[kstart]) 
            { Setup.Parameter.BaseAddr[k]=VMEParameter.BaseAddress[j]; if (k==NPar1-1) NoOfSubAddr[j]=NPar1-kstart; }
         else
            { NoOfSubAddr[j]=k-kstart; kstart=k; break; }
         }
      j++;
      }
   NoOfModules=j;
   }
NoOfCAENParameters=0;
for (j=0;j<NoOfModules;j++)
   {
   if ((VMEParameter.ModuleType[j]==1)||(VMEParameter.ModuleType[j]==2)||(VMEParameter.ModuleType[j]==3))
      NoOfCAENParameters+=NoOfSubAddr[j];
   }
//g_print("NoOfCAENParameters=%d \n",NoOfCAENParameters);
/*g_print("NoOfCAENDigitizerModule=%d NoOfMesytecDigitizerModule=%d\n",
          NoOfCAENDigitizerModule,NoOfMesytecDigitizerModule);*/
/*We want to find the No Of Scaler Modules, First Scaler Module, Last Scaler Module, Intermediate Scaler Modules and
  then set them CBLT, GEO address and other initialization*/
if (Setup.Scaler.NSc>0)                                                              //Check whether a scalar is present
   {
   VMEParameter.NoOfScalerModules=1;
   VMEParameter.ScalerBaseAddress[0]=Setup.Scaler.BaseAddr[0];
   VMEParameter.ScalerGeo[0]=Setup.Scaler.N[0];
   /*g_print("Setup.Scaler.N[0]=%d, Setup.Scaler.A=%d, Setup.Scaler.BaseAddr=0x%8X\n",Setup.Scaler.N[0],
             Setup.Scaler.A[0],Setup.Scaler.BaseAddr[0]);*/
   for (i=1,j=0;i<Setup.Scaler.NSc;i++)
      {
      NoOfChannelInV830[j]=0;
      if (Setup.Scaler.N[i]!=Setup.Scaler.N[i-1]) { VMEParameter.NoOfScalerModules++; j++; }
      VMEParameter.ScalerBaseAddress[j]=Setup.Scaler.BaseAddr[i];
      VMEParameter.ScalerGeo[j]=Setup.Scaler.N[i];
      /*g_print("Setup.Scaler.N[%d]=%d, Setup.Scaler.A=%d, Setup.Scaler.BaseAddr=0x%8X\n",i,
                Setup.Scaler.N[i],Setup.Scaler.A[i],Setup.Scaler.BaseAddr[i]);*/
      }
   if (Setup.Scaler.NSc==1) NoOfChannelInV830[0]=0;                                                //Only initialization
   //g_print("NoOfChannelInV830[j=%d]=0x%8X\n",j,NoOfChannelInV830[j]);
   for (i=1,j=0;i<Setup.Scaler.NSc;i++)
      {
      NoOfChannelInV830[j]++;
      if (Setup.Scaler.N[i]!=Setup.Scaler.N[i-1]) j++;
      }
   NoOfChannelInV830[VMEParameter.NoOfScalerModules-1]++;
   CumilativeScalerSubAddress=0;
   for (j=0;j<VMEParameter.NoOfScalerModules;j++)
      {
      //g_print("NoOfChannelInV830[j=%d]=0x%8X\n",j,NoOfChannelInV830[j]);
      V830ChannelEnableRegister=0;
      for (k=CumilativeScalerSubAddress;k<(CumilativeScalerSubAddress+NoOfChannelInV830[j]);k++)
         {
         V830ChannelEnableRegister+=(1<<Setup.Scaler.A[k]);
         }
      CumilativeScalerSubAddress=CumilativeScalerSubAddress+NoOfChannelInV830[j];
      //g_print("CumilativeScalerSubAddress=%d\n",CumilativeScalerSubAddress);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1100,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Base Address=0x%02X before setup\n",j+1, Data&0xFF);
      //Writing the bit pattern in Channel Enable Register for enabling individual channel as per Set up file
      Data=V830ChannelEnableRegister;
      //g_print("V830ChannelEnableRegister=0x%8X\n",V830ChannelEnableRegister);
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1100,&Data,cvA32_U_DATA,cvD32);
      }
   for (j=0;j<VMEParameter.NoOfScalerModules;j++)
      {
      Geo=VMEParameter.ScalerGeo[j];
      //g_print("VMEParameter.NoOfScalerModules=%u, Geo= %u\n",VMEParameter.NoOfScalerModules,Geo);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1110,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, Geo Address=0x%02X before software reset\n",j+1, Data&0x1F);
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1110,&Geo,cvA32_U_DATA,cvD16);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1110,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, Geo Address=0x%02X after software reset\n",j+1, Data&0x1F);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111E,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Control Register=0x%01X before setup\n",j+1, Data&0x3);
      if (j==0) Data=0x2;                                                                                 //First module
      else if (j==VMEParameter.NoOfScalerModules-1) Data=0x1;                                              //Last module
      else Data=0x3;                                                                               //Intermediate module
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111E,&Data,cvA32_U_DATA,cvD16);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111E,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Control Register=0x%01X after setup\n",j+1, Data&0x3);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111C,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Base Address=0x%02X before setup\n",j+1, Data&0xFF);
      Data=0x00CC; VMEParameter.ScalerCBLTBaseAddress=(Data&0xFF)<<24;
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111C,&Data,cvA32_U_DATA,cvD16);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111C,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Base Address=0x%02X after setup\n",j+1, Data&0xFF);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1108,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, V830 Control Register=0x%02X before setup\n",j+1, Data&0xFF);
      if (j==VMEParameter.NoOfScalerModules-1) Data=0x0031;                              //Enabling bus error and Header
                                         //Will work only with CAEN V830 Scaler - Also Clears MEB, Counter Registers etc
      else Data=0x0021;                                                                           //Enabling only Header
                                         //Will work only with CAEN V830 Scaler - Also Clears MEB, Counter Registers etc
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1108,&Data,cvA32_U_DATA,cvD16);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1108,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, V830 Control Register=0x%02X after setup\n",j+1, Data&0xFF);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1130,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, V830 BLT Evt no reg.=0x%02X before setup\n",j+1, Data&0xFF);
      Data=0x01;                                                                  //With Data=1-BLT reads only one event
                                    //Data=Any other value-BLT reads the requested number of bytes(VMEParameter.BltSize)
                                                                                  //Will work only with CAEN V830 Scaler
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1130,&Data,cvA32_U_DATA,cvD16);
                                            //Setting BLT Event number register - Also Clears MEB, Counter Registers etc
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1130,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, V830 BLT Evt no reg.=0x%02X after setup\n",j+1, Data&0xFF);
      }
   }
x=0; Geo=1; CumSubAddr=0; FirstMesytecModule=TRUE;
FirstCAENModule=TRUE; CAENDigitizerModule=0; MesytecDigitizerModule=0;
for (j=0;j<NoOfModules;j++)
   {
   if ((VMEParameter.ModuleType[j]==1)||(VMEParameter.ModuleType[j]==2)||(VMEParameter.ModuleType[j]==3))    //Only CAEN
      {
      CAENDigitizerModule++;
      // ......Setting up Geographical Adddress for all modules before acquisition starts ......
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1002,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Geo Address=0x%04X before software reset\n",j+1, Data&0xFFFF);
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1002,&Geo,cvA32_U_DATA,2);
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1002,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Geo Address=0x%04X after software reset\n",j+1, Data&0xFFFF);
      for (i=0;i<NoOfSubAddr[j];++i)
         {
         GeoAddr[CumSubAddr+i]=Geo;
         //g_print("i=%d, CumSubAddr=%d, NoOfSubAddr[j]=%d,Geo=%d\n",i,CumSubAddr,NoOfSubAddr[j],Geo);
         }
      Geo=Geo+1;
      CumSubAddr=CumSubAddr+NoOfSubAddr[j];
      //......Reset (software) all the modules before acquisition starts......
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Bit Set 1=0x%04X before software reset\n",j+1, Data&0xFFFF);
      Data=0x0080;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Bit Set 1=0x%04X after software reset\n",j+1, Data&0xFFFF);
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1008,&Data,cvA32_U_DATA,2);
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Bit Set 1=0x%04X after Bit Clear 1\n",j+1, Data&0xFFFF);
      //.......Software reset complete......setting up registers for CBLT mode...........
      Data=0x00CB; VMEParameter.CBLTBaseAddress=(Data&0xFF)<<24;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1004,&Data,cvA32_U_DATA,2);  //MCST/CBLT address register
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1004,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, CBLT base address=0x%04X\n",j+1, VMEParameter.CBLTBaseAddress);
      /*if (j==0) Data=0x0002;                        //First module
      else if (j==NoOfModules-1) Data=0x0001;       //Last module
      else Data=0x0003;                             //Intermediate module*/
      if (FirstCAENModule) Data=0x2;                                                                      //First module
      else if (CAENDigitizerModule==NoOfCAENDigitizerModule) Data=0x1;                                     //Last module
      else Data=0x3;                                                                               //Intermediate module
      FirstCAENModule=FALSE;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x101A,&Data,cvA32_U_DATA,2);  //MCST/CBLT control register
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x101A,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, CBLT control register content=0x%01X\n",j+1, Data&0x3);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Control register 1=0x%02X\n",j+1, Data&0x7F);
      Data=(Data|0x0020);
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
                                                                             //control register 1 for bus error enabling
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Control register 1=0x%02X\n",j+1, Data&0x7F);
      //......Finished setting up registers for CBLT mode..........Setting up Event trigger register...........
      Data=EVT_TRG_REG;
                  //Minimum 16 events in the buffer to generate interrupt and also event ready status defined in lamps.h
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1020,&Data,cvA32_U_DATA,2);
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1020,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, event trigger register=%d\n",j+1, Data&0x1F);
      //Finished setting up event trigger register.....Setting control register 1 to enable bus error
      Data=0x0020;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
                                                                     //Enabling bus error for all modules and blkend????
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Control register 1=%d\n",j+1, Data&0x7F);
      //Finished setting up control register 1......Setting up LLD.............
      if (ModuleThreshold[VMEParameter.StnIndex[j]][0]>=510)
         {
         Data=0x0100;                                                            //Clearing Bit9 in bit clear 2 register
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1034,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         }
      else
         {
         Data=0x0100;                                              //Setting bit set 2 register for STEP_TH =x2 (Bit8=1)
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         }
      Offset=0x1080;
      l=0;
      for (i=0;i<NoOfSubAddr[j];++i)
         {
         //g_print("Setup.Parameter.A[x+%d]=%d\n",i,Setup.Parameter.A[x+i]);
         if (l==Setup.Parameter.A[x+i])
            {
            if (ModuleThreshold[VMEParameter.StnIndex[j]][0]>=510) Data=ModuleThreshold[VMEParameter.StnIndex[j]][l]/16;
            else Data=ModuleThreshold[VMEParameter.StnIndex[j]][l]/2;
            //Data=LLD[j]; Old code for common LLDs; Above we have new code for individual LLDs
            Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            InterpretVmeRet(Ret);                                                        //Setting LLD for used channels
            //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            /*g_print("In if loop...Used Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                      i,Setup.Parameter.A[x+i],Data,Offset);*/
            if (!VMEParameter.VersionChoice) Offset=Offset+2; else Offset=Offset+4;
            ++l;
            }
         else if (l<Setup.Parameter.A[x+i])                    //Setting kill bit in LLD register to disable the channel
            {
            for (k=l;k<Setup.Parameter.A[x+i];++l,++k)
               {
               Data=0x0100;Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               InterpretVmeRet(Ret);
               //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               /*g_print("In else loop with kill bit...Unused Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                          k,Setup.Parameter.A[x+i],Data,Offset);*/
               if (!VMEParameter.VersionChoice) Offset=Offset+2; else Offset=Offset+4;
               }
            if (ModuleThreshold[j][0]>=510) Data=ModuleThreshold[j][l]/16; else Data=ModuleThreshold[j][l]/2;
            //Data=LLD[j]; Old code for common LLDs; Above we have new code for individual LLDs
            Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            InterpretVmeRet(Ret);
            //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            /*g_print("In else loop with LLD value...Used Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                       k,Setup.Parameter.A[x+i],Data,Offset);*/
            if (!VMEParameter.VersionChoice) Offset=Offset+2; else Offset=Offset+4;
            ++l;
            }
         }
      if ((!VMEParameter.VersionChoice[j])&&(Setup.Parameter.A[x+NoOfSubAddr[j]-1]!=31))
         {
         for (m=Setup.Parameter.A[x+NoOfSubAddr[j]-1]+1;m<32;++m)
            {
            Data=0x0100;Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            /*g_print("Enabling kill bit for Sub-addresses upto 31...Unused Sub-Address=%d,Data=%d,Offset=0x%04X\n",
                       m,Data,Offset);*/
            Offset=Offset+2;
            }
         }
      else if ((VMEParameter.VersionChoice[j])&&(Setup.Parameter.A[x+NoOfSubAddr[j]-1]!=15))
         {
         for (m=Setup.Parameter.A[x+NoOfSubAddr[j]-1]+1;m<16;++m)
            {
            Data=0x0100;Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            /*g_print("Enabling kill bit for Sub-addresses upto 15...Unused Sub-Address=%d,Data=%d,Offset=0x%04X\n",
                       m,Data,Offset);*/
            Offset=Offset+4;
            }
         }
      x=x+NoOfSubAddr[j];
      // .......... LLD setup complete .................setting event counter ...............
      Data=0x4000;                                                                //To clear bit15 in bit set 2 register
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1034,&Data,cvA32_U_DATA,2);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
      //if (!(Data&0x4000)) g_print("Mode set to increment event counter only on accepted triggers\n");
      //Data=0xFFFF;          // dummy write with any data to 0x1040 is sufficient to reset event counter
      //Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1040,&Data,cvA32_U_DATA,2);
      }
   else if (VMEParameter.ModuleType[j]==4)
      {
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6004,&Geo,cvA32_U_DATA,cvD16);
                                                          //Setting module id (Geographical Address) for Mesytec Modules
      Data=4;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6042,&Data,cvA32_U_DATA,cvD16);
                                                                            //Setting up ADC Resolution to best possible
      Data=1;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6060,&Data,cvA32_U_DATA,cvD16);
                                                                                        //Setting up Input range to 10 V
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6004,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module Id set as %d for Mesytec module %d, Geo=%d \n",Data&0xFF, j+1, Geo);
      for (i=0;i<NoOfSubAddr[j];++i)
         {
         GeoAddr[CumSubAddr+i]=Geo;
         //g_print("i=%d, CumSubAddr=%d, NoOfSubAddr[j]=%d,Geo=%d\n",i, CumSubAddr, NoOfSubAddr[j],Geo);
         }
      Geo=Geo+1;
      CumSubAddr=CumSubAddr+NoOfSubAddr[j];
      MesytecDigitizerModule++;
      if (FirstMesytecModule) 
         {
         Data=0xA2;                                                          //Data word for enabling first module, MCST
         //g_print("Base Address of 1st module=0x%8X \n",VMEParameter.BaseAddress[j]);
         }
      else if (MesytecDigitizerModule==NoOfMesytecDigitizerModule)
         {
         Data=0x8A;                                                       //Data word for enabling last module, and MCST
         //g_print("Base Address of last module=0x%8X \n",VMEParameter.BaseAddress[j]);
         }
      else
         {
         Data=0x82;                                                          //Enabling MCST in the intermediate modules
         //g_print("Base Address of intermediate module=0x%8X \n",VMEParameter.BaseAddress[j]);
         }
      FirstMesytecModule=FALSE;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6020,&Data,cvA32_U_DATA,cvD16);
                                                                //Setting CBLT/MCST control register for Mesytec Modules
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6020,&Data,cvA32_U_DATA,cvD16);
      //g_print("CBLT/MCST Control Register set as 0x%X for Mesytec module %d \n",Data,j+1);
      Data=0xBB; VMEParameter.MCSTBaseAddress=(Data&0xFF)<<24;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6024,&Data,cvA32_U_DATA,cvD16);
                                               //Setting MCST address for Mesytec Modules - Actually 0xBB is the default
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6024,&Data,cvA32_U_DATA,cvD16);
      //g_print("MCST Base address set as 0x%8X for Mesytec module %d \n",(Data<<24),j+1);
      Data=0xAA; VMEParameter.CBLTBaseAddress=(Data&0xFF)<<24;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6022,&Data,cvA32_U_DATA,cvD16);
                                                                              //Setting CBLT address for Mesytec Modules
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6022,&Data,cvA32_U_DATA,cvD16);
      //g_print("CBLT Base address set as 0x%8X for Mesytec module %d \n",(Data<<24),j+1);
      /*
      if (MesytecDigitizerModule==NoOfMesytecDigitizerModule)
         {
         Data=1;                                       //Terminate Gate0 of ECL output for last module in the CBLT chain
         CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6062,&Data,cvA32_U_DATA,cvD16);
         }
      */
      //............LLD Setup for Mesytec Modules starts here.......................
      Offset=0x4000;
      l=0; //g_print ("NoOfSubAddr[%d]=%d \n",j,NoOfSubAddr[j]);
      for (i=0;i<NoOfSubAddr[j];++i)
         {
         if (l==Setup.Parameter.A[x+i])
            {
            //Data=VMEParameter.LLD[j];
            Data=ModuleThreshold[VMEParameter.StnIndex[j]][l];
            CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,cvD16);
                                                                                         //Setting LLD for used channels
            CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,cvD16);
            /*g_print("In if loop...Used Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                      i,Setup.Parameter.A[x+i],Data,Offset);*/
            Offset=Offset+2;++l;
            }
         else if (l<Setup.Parameter.A[x+i])                    //Setting kill bit in LLD register to disable the channel
            {
            for (k=l;k<Setup.Parameter.A[x+i];++l,++k)
               {
               Data=0x1FFF;CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,cvD16);
               CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,cvD16);
               /*g_print("In else loop with kill bit...Unused Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                         k,Setup.Parameter.A[x+i],Data,Offset);*/
               Offset=Offset+2;
               }
            Data=VMEParameter.LLD[j];
            CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,cvD16);
            CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,cvD16);
            /*g_print("In else loop with LLD value...Used Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                       k,Setup.Parameter.A[x+i],Data,Offset);*/
            Offset=Offset+2; ++l;
            }
         }
      if (Setup.Parameter.A[x+NoOfSubAddr[j]-1]!=31)
         {
         for (m=Setup.Parameter.A[x+NoOfSubAddr[j]-1]+1;m<32;++m)
            {
            Data=0x1FFF;CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,cvD16);
            CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,cvD16);
            /*g_print("Enabling kill bit for Sub-addresses upto 31...Unused Sub-Address=%d,Data=%d,Offset=0x%04X\n",
                      m,Data,Offset);*/
            Offset=Offset+2;
            }
         }
      x=x+NoOfSubAddr[j];
      //............LLD Setup for Mesytec MADC32 Module ends here.......................
      }
   else if (VMEParameter.ModuleType[j]==5)                                             //Initialization of MTDC32 Module
      {
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6004,&Geo,cvA32_U_DATA,cvD16);
                                                          //Setting module id (Geographical Address) for Mesytec Modules
      Data=3;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6060,&Data,cvA32_U_DATA,cvD16);
                                                                     //Setting up Negative edge for both banks of inputs
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6004,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module Id set as %d for Mesytec module %d, Geo=%d \n",Data&0xFF, j+1, Geo);
      for (i=0;i<NoOfSubAddr[j];++i)
         {
         GeoAddr[CumSubAddr+i]=Geo;
         //g_print("i=%d, CumSubAddr=%d, NoOfSubAddr[j]=%d,Geo=%d\n",i, CumSubAddr, NoOfSubAddr[j],Geo);
         }
      Geo=Geo+1;
      CumSubAddr=CumSubAddr+NoOfSubAddr[j];
      MesytecDigitizerModule++;
      if (FirstMesytecModule)
         {
         Data=0xA2;                                                          //Data word for enabling first module, MCST
         //g_print("Base Address of 1st module=0x%8X \n",VMEParameter.BaseAddress[j]);
         }
      else if (MesytecDigitizerModule==NoOfMesytecDigitizerModule)
         {
         Data=0x8A;                                                       //Data word for enabling last module, and MCST
         //g_print("Base Address of last module=0x%8X \n",VMEParameter.BaseAddress[j]);
         }
      else
         {
         Data=0x82;                                                          //Enabling MCST in the intermediate modules
         //g_print("Base Address of intermediate module=0x%8X \n",VMEParameter.BaseAddress[j]);
         }
      FirstMesytecModule=FALSE;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6020,&Data,cvA32_U_DATA,cvD16);
                                                                //Setting CBLT/MCST control register for Mesytec Modules
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6020,&Data,cvA32_U_DATA,cvD16);
      //g_print("CBLT/MCST Control Register set as 0x%2X for Mesytec module %d \n",Data,j+1);
      Data=0xBB; VMEParameter.MCSTBaseAddress=(Data&0xFF)<<24;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6024,&Data,cvA32_U_DATA,cvD16);
                                               //Setting MCST address for Mesytec Modules - Actually 0xBB is the default
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6024,&Data,cvA32_U_DATA,cvD16);
      //g_print("MCST Base address set as 0x%8X for Mesytec module %d \n",(Data<<24),j+1);
      Data=0xAA; VMEParameter.CBLTBaseAddress=(Data&0xFF)<<24;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6022,&Data,cvA32_U_DATA,cvD16);
                                                                              //Setting CBLT address for Mesytec Modules
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6022,&Data,cvA32_U_DATA,cvD16);
      //g_print("CBLT Base address set as 0x%8X for Mesytec module %d \n",(Data<<24),j+1);
      /*
      if (MesytecDigitizerModule==NoOfMesytecDigitizerModule)
         {
         Data=1;                                    //Terminate Trigger0 of ECL output for last module in the CBLT chain
         CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6062,&Data,cvA32_U_DATA,cvD16);
         }
      */
      Data=0;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6040,&Data,cvA32_U_DATA,cvD16);
                                         //Setting up common bank operation mode (same trigger for both bank1 and bank2)
      Data=1;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6058,&Data,cvA32_U_DATA,cvD16);
                                                                             //Setting up Trigger from T0 for both banks
      Data=1;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x605A,&Data,cvA32_U_DATA,cvD16);
                                                                                  //Setting up Trigger from T0 for bank2
      Data=0;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6068,&Data,cvA32_U_DATA,cvD16);
                                                                            //Setting up Trigger 0 and 1 from NIM-inputs
      Data=0;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6044,&Data,cvA32_U_DATA,cvD16);
                                                                           //Setting up output format as time difference
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6054,&VMEParameter.MTDC32WindowWidth[j],
                         cvA32_U_DATA,cvD16);                                        //Setting up window width for bank0
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6056,&VMEParameter.MTDC32WindowWidth[j],
                         cvA32_U_DATA,cvD16);                                        //Setting up window width for bank1
      if (VMEParameter.MTDC32WindowWidth[j]<=256)       {Data=2;TdcResolution= 3.9;} //Set Resolution of  3.9 ps/Channel     
      else if (VMEParameter.MTDC32WindowWidth[j]<=512)  {Data=3;TdcResolution= 7.8;} //Set Resolution of  7.8 ps/Channel 
      else if (VMEParameter.MTDC32WindowWidth[j]<=1024) {Data=4;TdcResolution=15.6;} //Set Resolution of 15.6 ps/Channel
      else if (VMEParameter.MTDC32WindowWidth[j]<=2048) {Data=5;TdcResolution=31.3;} //Set Resolution of 31.3 ps/Channel
      else if (VMEParameter.MTDC32WindowWidth[j]<=4096) {Data=6;TdcResolution=62.5;} //Set Resolution of 62.5 ps/Channel
      else if (VMEParameter.MTDC32WindowWidth[j]<=8192) {Data=7;TdcResolution=125; } //Set Resolution of 125  ps/Channel
      else {Data=8;TdcResolution=250;}                                               //Set Resolution of 250  ps/Channel
      g_print("Resolution set as %.1f ps for MTDC32 \n",TdcResolution);
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6042,&Data,cvA32_U_DATA,cvD16);
                                                                            //Setting up TDC Resolution to best possible
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6050,&VMEParameter.MTDC32WindowStart[j],
                         cvA32_U_DATA,cvD16);                                        //Setting up window start for bank0 
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6052,&VMEParameter.MTDC32WindowStart[j],
                         cvA32_U_DATA,cvD16);                                        //Setting up window start for bank1
      Data=3;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x605C,&Data,cvA32_U_DATA,cvD16);
                                                                 //Setting to accept only first hit from bank0 and bank1
      }
   }
for (j=0;j<NoOfModules;j++)                                                                        //CAEN V775 TDC setup
   {
   if ((VMEParameter.ModuleType[j]==2))
      {
      //g_print("VMEParameter.ModuleType[%d]=%d\n",j, VMEParameter.ModuleType[j]);
      Data=1<<10;
      if (VMEParameter.V775TdcMode[j]==0) Offset=0x1034;                                                  //Common Start
      else Offset=0x1032;                                                                                  //Common Stop
      //g_print("VMEParameter.V775TdcMode=%d\n",VMEParameter.V775TdcMode[j]);
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
      //g_print ("Offset=0x%4X, Data=0x%4X\n",Offset,Data);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
      InterpretVmeRet(Ret);
      if (VMEParameter.V775TdcFullRange[j]==1200)     Data=31;
      else if (VMEParameter.V775TdcFullRange[j]==1100) Data=35;
      else if (VMEParameter.V775TdcFullRange[j]==1000) Data=39;
      else if (VMEParameter.V775TdcFullRange[j]==900)  Data=44;
      else if (VMEParameter.V775TdcFullRange[j]==800)  Data=50;
      else if (VMEParameter.V775TdcFullRange[j]==700)  Data=58;
      else if (VMEParameter.V775TdcFullRange[j]==600)  Data=68;
      else if (VMEParameter.V775TdcFullRange[j]==500)  Data=82;
      else if (VMEParameter.V775TdcFullRange[j]==400)  Data=103;
      else if (VMEParameter.V775TdcFullRange[j]==300)  Data=139;
      else if (VMEParameter.V775TdcFullRange[j]==200)  Data=215;
      else                                             Data=255;
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1060,&Data,cvA32_U_DATA,2);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1060,&Data,cvA32_U_DATA,2);
      //g_print ("Data after V775TdcFullRange setting=0x%4X\n",Data);
      InterpretVmeRet(Ret);                                                                       //TDC Full range setup
      }
   }
   //....Setting up Iped register of CAEN VME QDC V862 for pedestal correction
for (j=0;j<NoOfModules;j++)                                                                        //CAEN V862 QDC setup
   {
   if ((VMEParameter.ModuleType[j]==3))
      {
      //g_print("VMEParameter.ModuleType[%d]=%d\n",j, VMEParameter.ModuleType[j]);
      Data=VMEParameter.V862Pedestal[j];
      Offset=0x1060;
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
      //g_print ("Pedestal set as =%d \n",Data);
      InterpretVmeRet(Ret);
      }
   }
//......Setting ADC's in Offline mode, Event counter reset, Data Reset and setting ADC's back to Online mode ...........

for (j=0;j<NoOfModules;j++)                                                                  //Set ADC's to offline mode
   if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3)) VMEParameter.McstBuff[j]=0x2;
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
//InterpretVmeRet(Ret);
for (j=0;j<NoOfModules;j++)
    /*if (VMEParameter.ModuleType[j]==4)*/ VMEParameter.McstBuff[j]=0x0;             //Stop Acquisition for Mesytec MADC
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x603A,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)
   /*if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))*/
   VMEParameter.McstBuff[j]=1<<12;                                            //Set EMPTY PROG bit in bit set 2 register
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
//InterpretVmeRet(Ret);                   //Header and EOB written into the output buffer even if there is no valid data
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=1<<3;                                 //Overrange checking disabled
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,
                          NoOfModules*2,0x09,2,&BytesRead);
for (j=0;j<NoOfModules;j++)
   /*if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))*/
   VMEParameter.McstBuff[j]=0xFF;                           //Dummy write to 0x1040 is sufficient to reset event counter
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1040,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)
   /*if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))*/
   VMEParameter.McstBuff[j]=0x4;                                                                        //For data reset
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
usleep(100000);                                                                 //Seems to be very important for the TDC

for (j=0;j<NoOfModules;j++)
    /*if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))*/
    VMEParameter.McstBuff[j]=0x4;                              //Changing the module from permanent data reset to normal
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1034,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);

/*
Data=0;
CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x603A,&Data,cvA32_U_DATA,cvD16);              //Stop Acquisition
CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x603A,&Data,cvA32_U_DATA,cvD16);
if (Data==0) g_print("Stop Acquisition done for Mesytec module %d\n",j+1);
Data=1;
CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6036,&Data,cvA32_U_DATA,cvD16);   //Multievent register setting
CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6036,&Data,cvA32_U_DATA,cvD16);
if (Data==1) g_print("Set multievent register for Mesytec module %d as %d\n",j+1,Data&7);
Data=1;
CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x6090,&Data,cvA32_U_DATA,cvD16);                //Reset counters
CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x6090,&Data,cvA32_U_DATA,cvD16);
if (Data==1) g_print("Counter A resetted for Mesytec module %d\n",j+1);
*/

for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=0x3;
                                                //Multievent register setting for Mesytec Modules - single Event Readout
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x6036,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=1;
                                                                //Max transfer data register setting for Mesytec Modules
                                       //*** with Max transfer data setting of 1 event, DAQ goes out of step quickly ***
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x601A,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=1;                             //Setting event marker as time stamp
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x6038,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=2;          //Set Data length format register - Set to 32 bit words 
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x6032,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead); 
for (j=0;j<NoOfModules;j++)
    //if (VMEParameter.ModuleType[j]==4)
    VMEParameter.McstBuff[j]=0x1;                                                   //Reset counters for mesytec Modules
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x6090,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)
    //if (VMEParameter.ModuleType[j]==4)
    VMEParameter.McstBuff[j]=0x0;                                            //For data (fifo) reset for Mesytec Modules
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x603C,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)
    //if (VMEParameter.ModuleType[j]==4)
    VMEParameter.McstBuff[j]=0x0;                                                //For readout reset for Mesytec Modules
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x6034,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
// .......................... Data Reset completed ............................
for (j=0;j<NoOfModules;j++)
    //if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))
    VMEParameter.McstBuff[j]=0x2;                                                     //To set ADC's back to online mode
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1034,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
//InterpretVmeRet(Ret);
for (j=0;j<NoOfModules;j++)
    //if (VMEParameter.ModuleType[j]==4)
    VMEParameter.McstBuff[j]=0x1;                                         //To start acquisition in mesytec MADC modules
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x603A,&VMEParameter.McstBuff,NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
//InterpretVmeRet(Ret);

if (Setup.Scaler.NSc>0)                                                              //Check whether a scalar is present
   {
   for (j=0;j<VMEParameter.NoOfScalerModules;j++)
      {
      Data=0xFFFF;                                                                              //V830 scaler Data Reset
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1122,&Data,cvA32_U_DATA,cvD16);
                                                                                     //Clears MEB, Counter Registers etc
      }
   }

for (i=0;i<NPar1;++i)
   {
   ParaNo[GeoAddr[i]][Setup.Parameter.A[i]]=i+1;
   /*g_print("Parameter No=%d,Geo=%d,Setup.Parameter.A=%d,Setup.Parameter.N=%d,Setup.Parameter.BaseAddr=0x%08X\n",
              ParaNo[GeoAddr[i]][Setup.Parameter.A[i]],GeoAddr[i],Setup.Parameter.A[i],Setup.Parameter.N[i],
              Setup.Parameter.BaseAddr[i]);*/
   }
VMEParameter.AddressMode=cvA32_U_BLT;
DataWidth=4; VMEParameter.DataWidth=DataWidth; //g_print("Data width=%u\n",DataWidth*8);
EvtSize=NPar1; //NoOfModules*32;

//Give command to V977 IO Module (if present) to release the Master Gate
if (IOModule.Use)
   {
   sleep(1);
   Data=IOModule.Data;
   Ret=CAENVME_WriteCycle(BHandle,IOModule.BaseAddress,&Data,cvA32_U_DATA,cvD16);
   }
}
//----------------------------------------------------------------------------------------------------------------------
void VMEInitInterruptCBLT(int32_t BHandle)
{
guint32 Offset,DataWidth,BaseAddr,Data,Geo,BytesRead;
const gchar *OffsetHex,*AddressWidth,*BaseAddrHex;
gint Id,i,j,k,m,kstart,MaxNoOfSubAddr,l,x,CumSubAddr;
guint32 LLD[2*MAX_VME_STNS];
guint32 V830ChannelEnableRegister,NoOfChannelInV830[2*MAX_VME_STNS],CumilativeScalerSubAddress;
CVErrorCodes    Ret;

CAENVME_SystemReset(BHandle);
Offset=0x0000;
kstart=0;
//g_print("Offset=0x%X\n",Offset);
for (i=0,j=0;i<2*MAX_VME_STNS;i++)
   {
   if (Setup.Hardware.Modules[i]!=0)                //Creating a database of non-empty stations and their (Base) Address
      {
      BaseAddrHex=Setup.Hardware.Properties[i].BaseAddr;
      VMEParameter.BaseAddress[j]=strtoul(BaseAddrHex,NULL,16);
      VMEParameter.Address[j]=VMEParameter.BaseAddress[j]+Offset;
      VMEParameter.LLD[j]=Setup.Hardware.Properties[i].AdcLLD;
      VMEParameter.ModuleType[j]=Setup.Hardware.Modules[i];
      if (VMEParameter.ModuleType[j]==2)
         {
         VMEParameter.V775TdcMode[j]=Setup.Hardware.Properties[i].V775TdcMode;
         VMEParameter.V775TdcFullRange[j]=Setup.Hardware.Properties[i].V775TdcFullRange;
         /*g_print("Stn No=%d, Base Address=0x%X, VMEParameter.V775TdcMode=%d, VMEParameter.V775TdcFullRange=%d\n",
                   i+1,VMEParameter.BaseAddress[j],VMEParameter.V775TdcMode[j],VMEParameter.V775TdcFullRange[j]);*/
         }
      if (VMEParameter.ModuleType[j]==3)
         {
         VMEParameter.V862Pedestal[j]=Setup.Hardware.Properties[i].V862Pedestal;
         /*g_print("Stn No=%d, Base Address=0x%X, VMEParameter.V862Pedestal=%d\n",i+1,
                   VMEParameter.BaseAddress[j],VMEParameter.V862Pedestal[j]);*/
         }
      /*g_print("Stn No=%d, Base Address=0x%X, LLD=%d, ModuleType=%d \n",i+1,VMEParameter.BaseAddress[j],
                VMEParameter.LLD[j],VMEParameter.ModuleType[j]);*/
      for (k=kstart;k<NPar1;++k)
         {
         if (Setup.Parameter.N[k]==Setup.Parameter.N[kstart]) 
            {
            Setup.Parameter.BaseAddr[k]=VMEParameter.BaseAddress[j]; if (k==NPar1-1) NoOfSubAddr[j]=NPar1-kstart;
            }
         else
            { NoOfSubAddr[j]=k-kstart; kstart=k; break; }
         }
      j++;
      }
   NoOfModules=j;
   }

//We want to find the No Of Scaler Modules, First Scaler Module, Last Scaler Module, Intermediate Scaler Modules and
//then set them CBLT, GEO address and other initialization
if (Setup.Scaler.NSc>0)                                                              //Check whether a scalar is present
   {
   VMEParameter.NoOfScalerModules=1;
   VMEParameter.ScalerBaseAddress[0]=Setup.Scaler.BaseAddr[0];
   VMEParameter.ScalerGeo[0]=Setup.Scaler.N[0];
   /*g_print("Setup.Scaler.N[0]=%d, Setup.Scaler.A=%d, Setup.Scaler.BaseAddr=0x%8X\n",Setup.Scaler.N[0],
             Setup.Scaler.A[0],Setup.Scaler.BaseAddr[0]);*/
   for (i=1,j=0;i<Setup.Scaler.NSc;i++)
      {
      NoOfChannelInV830[j]=0;
      if (Setup.Scaler.N[i]!=Setup.Scaler.N[i-1]) { VMEParameter.NoOfScalerModules++; j++; }
      VMEParameter.ScalerBaseAddress[j]=Setup.Scaler.BaseAddr[i];
      VMEParameter.ScalerGeo[j]=Setup.Scaler.N[i];
      /*g_print("Setup.Scaler.N[%d]=%d, Setup.Scaler.A=%d, Setup.Scaler.BaseAddr=0x%8X\n",i,Setup.Scaler.N[i],
                Setup.Scaler.A[i],Setup.Scaler.BaseAddr[i]);*/
      }
   if (Setup.Scaler.NSc==1) NoOfChannelInV830[0]=0;                                                //Only initialization
   //g_print("NoOfChannelInV830[j=%d]=0x%8X\n",j,NoOfChannelInV830[j]);
   for (i=1,j=0;i<Setup.Scaler.NSc;i++)
      {
      NoOfChannelInV830[j]++;
      if (Setup.Scaler.N[i]!=Setup.Scaler.N[i-1]) j++;
      }
   NoOfChannelInV830[VMEParameter.NoOfScalerModules-1]++;
   CumilativeScalerSubAddress=0;
   for (j=0;j<VMEParameter.NoOfScalerModules;j++)
      {
      //g_print("NoOfChannelInV830[j=%d]=0x%8X\n",j,NoOfChannelInV830[j]);
      V830ChannelEnableRegister=0;
      for (k=CumilativeScalerSubAddress;k<(CumilativeScalerSubAddress+NoOfChannelInV830[j]);k++)
         {
         V830ChannelEnableRegister+=(1<<Setup.Scaler.A[k]);
         }
      CumilativeScalerSubAddress=CumilativeScalerSubAddress+NoOfChannelInV830[j];
      //g_print("CumilativeScalerSubAddress=%d\n",CumilativeScalerSubAddress);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1100,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Base Address=0x%02X before setup\n",j+1, Data&0xFF);

      //Writing the bit pattern in Channel Enable Register for enabling individual channel as per Set up file
      Data=V830ChannelEnableRegister;
      //g_print("V830ChannelEnableRegister=0x%8X\n",V830ChannelEnableRegister);
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1100,&Data,cvA32_U_DATA,cvD32);
      }
   for (j=0;j<VMEParameter.NoOfScalerModules;j++)
      {
      Geo=VMEParameter.ScalerGeo[j]; 
      //g_print("VMEParameter.NoOfScalerModules=%u, Geo= %u\n",VMEParameter.NoOfScalerModules,Geo);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1110,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, Geo Address=0x%02X before software reset\n",j+1, Data&0x1F);
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1110,&Geo,cvA32_U_DATA,cvD16);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1110,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, Geo Address=0x%02X after software reset\n",j+1, Data&0x1F);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111E,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Control Register=0x%01X before setup\n",j+1, Data&0x3);
      if (j==0) Data=0x2;                                                                                 //First module
      else if (j==VMEParameter.NoOfScalerModules-1) Data=0x1;                                              //Last module
      else Data=0x3;                                                                               //Intermediate module
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111E,&Data,cvA32_U_DATA,cvD16);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111E,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Control Register=0x%01X after setup\n",j+1, Data&0x3);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111C,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Base Address=0x%02X before setup\n",j+1, Data&0xFF);
      Data=0x00CC; VMEParameter.ScalerCBLTBaseAddress=(Data&0xFF)<<24;
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111C,&Data,cvA32_U_DATA,cvD16);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x111C,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, CBLT Base Address=0x%02X after setup\n",j+1, Data&0xFF);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1108,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, V830 Control Register=0x%02X before setup\n",j+1, Data&0xFF);
      if (j==VMEParameter.NoOfScalerModules-1) Data=0x0031;                              //Enabling bus error and Header
                                          //Will work only with CAEN V830 Scaler. Also Clears MEB, Counter Registers etc
      else Data=0x0021;                                                                           //Enabling only Header
                                         //Will work only with CAEN V830 Scaler - Also Clears MEB, Counter Registers etc
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1108,&Data,cvA32_U_DATA,cvD16);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1108,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, V830 Control Register=0x%02X after setup\n",j+1, Data&0xFF);
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1130,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, V830 BLT Evt no reg.=0x%02X before setup\n",j+1, Data&0xFF);
      Data=0x01;                                                                  //With Data=1-BLT reads only one event
                                    //Data=Any other value-BLT reads the requested number of bytes(VMEParameter.BltSize)
                                                                                  //Will work only with CAEN V830 Scaler
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1130,&Data,cvA32_U_DATA,cvD16);
                                            //Setting BLT Event number register - Also Clears MEB, Counter Registers etc
      //CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1130,&Data,cvA32_U_DATA,cvD16);
      //g_print("Module no=%d, V830 BLT Evt no reg.=0x%02X after setup\n",j+1, Data&0xFF);
      }
   }

x=0; Geo=1; CumSubAddr=0;
for (j=0;j<NoOfModules;j++)
   {
   if ((VMEParameter.ModuleType[j]==1)||(VMEParameter.ModuleType[j]==2)||(VMEParameter.ModuleType[j]==3))    //Only CAEN
      {
      // ......Setting up Geographical Adddress for all modules before acquisition starts ......
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1002,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Geo Address=0x%04X before software reset\n",j+1, Data&0xFFFF);
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1002,&Geo,cvA32_U_DATA,2);
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1002,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Geo Address=0x%04X after software reset\n",j+1, Data&0xFFFF);
      for (i=0;i<NoOfSubAddr[j];++i)
         {
         GeoAddr[CumSubAddr+i]=Geo;
         //g_print("i=%d, CumSubAddr=%d, NoOfSubAddr[j]=%d,Geo=%d\n",i, CumSubAddr, NoOfSubAddr[j],Geo);
         }
      Geo=Geo+1;
      CumSubAddr=CumSubAddr+NoOfSubAddr[j];
      // ......Reset (software) all the modules before acquisition starts ......
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Bit Set 1=0x%04X before software reset\n",j+1, Data&0xFFFF);
      Data=0x0080;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Bit Set 1=0x%04X after software reset\n",j+1, Data&0xFFFF);
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1008,&Data,cvA32_U_DATA,2);
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1006,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Bit Set 1=0x%04X after Bit Clear 1\n",j+1, Data&0xFFFF);
      // Software reset complete......setting up registers for CBLT mode...........
      Data=0x00CB; VMEParameter.CBLTBaseAddress=(Data&0xFF)<<24;
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1004,&Data,cvA32_U_DATA,2);  //MCST/CBLT address register
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1004,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, CBLT base address=0x%04X\n",j+1, VMEParameter.CBLTBaseAddress);
      if (j==0) Data=0x0002;                                                                              //First module
      else if (j==NoOfModules-1) Data=0x0001;                                                              //Last module
      else Data=0x0003;                                                                            //Intermediate module
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x101A,&Data,cvA32_U_DATA,2);  //MCST/CBLT control register
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x101A,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, CBLT control register content=0x%01X\n",j+1, Data&0x3);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Control register 1=0x%02X\n",j+1, Data&0x7F);
      Data=(Data|0x0024);
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
                                                                             //Control register 1 for bus error enabling
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Control register 1=0x%02X\n",j+1, Data&0x7F);
      //Finished setting up registers for CBLT mode..........Setting up Event trigger register...........
      Data=EVT_TRG_REG;
                  //Minimum 16 events in the buffer to generate interrupt and also event ready status defined in lamps.h
      CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1020,&Data,cvA32_U_DATA,2);
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1020,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, event trigger register=%d\n",j+1, Data&0x1F);
      //Finished setting up event trigger register.....Setting control register 1 to enable bus error
      //Data=0x0020;
      //CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
                                                                     //Enabling bus error for all modules and blkend????
      //CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1010,&Data,cvA32_U_DATA,2);
      //g_print("Module no=%d, Control register 1=%d\n",j+1, Data&0x7F);
      //Finished setting up control register 1......Setting up LLD.............
      if (VMEParameter.LLD[j]>=510)
         {
         LLD[j]=VMEParameter.LLD[j]/16;
         Data=0x0100;                                                            //Clearing Bit9 in bit clear 2 register
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1034,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         }
      else
         {
         LLD[j]=VMEParameter.LLD[j]/2;
         Data=0x0100;                                              //Setting bit set 2 register for STEP_TH =x2 (Bit8=1)
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         }
      Offset=0x1080;
      l=0;
      for (i=0;i<NoOfSubAddr[j];++i)
         {
         if (l==Setup.Parameter.A[x+i])
            {
            Data=LLD[j];Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            InterpretVmeRet(Ret);                                                            //Set LLD for used channels
            //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            /*g_print("In if loop...Used Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                      i,Setup.Parameter.A[x+i],Data,Offset);*/
            Offset=Offset+2;++l;
            }
         else if (l<Setup.Parameter.A[x+i])                    //Setting kill bit in LLD register to disable the channel
            {
            for (k=l;k<Setup.Parameter.A[x+i];++l,++k)
               {
               Data=0x0100;Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               InterpretVmeRet(Ret);
               //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               /*g_print("In else loop with kill bit...Unused Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                          k,Setup.Parameter.A[x+i],Data,Offset);*/
               Offset=Offset+2;
               }
            Data=LLD[j];Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            InterpretVmeRet(Ret);
            //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
            /*g_print("In else loop with LLD value...Used Sub-Address=%d,Setup.Parameter.A[x+i]=%d,Data=%d,Offset=0x%04X\n",
                      k,Setup.Parameter.A[x+i],Data,Offset);*/
            Offset=Offset+2;++l;
            }
         }
         if (Setup.Parameter.A[x+NoOfSubAddr[j]-1]!=31)
            {
            for (m=Setup.Parameter.A[x+NoOfSubAddr[j]-1]+1;m<32;++m)
               {
               Data=0x0100;Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               InterpretVmeRet(Ret);
               //Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
               /*g_print("Enabling kill bit for Sub-addresses upto 31...Unused Sub-Address=%d,Data=%d,Offset=0x%04X\n",
                          m,Data,Offset);*/
               Offset=Offset+2;
               }
            }
         x=x+NoOfSubAddr[j];
         // .......... LLD setup complete .................setting event counter ...............
         Data=0x4000;                                                             //To clear bit15 in bit set 2 register
         Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1034,&Data,cvA32_U_DATA,2);
         InterpretVmeRet(Ret);
         CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
         //if (!(Data&0x4000)) g_print("Mode set to increment event counter only on accepted triggers\n");
         //Data=0xFFFF;          // dummy write with any data to 0x1040 is sufficient to reset event counter
         //Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1040,&Data,cvA32_U_DATA,2);
         //InterpretVmeRet(Ret);
      }
   }
for (j=0;j<NoOfModules;j++)                                                                        //CAEN V775 TDC setup
   {
   if ((VMEParameter.ModuleType[j]==2))
      {
      //g_print("VMEParameter.ModuleType[%d]=%d\n",j, VMEParameter.ModuleType[j]);
      Data=1<<10;
      if (VMEParameter.V775TdcMode[j]==0) Offset=0x1034;                                                  //Common Start
      else Offset=0x1032;                                                                                  //Common Stop
      //g_print("VMEParameter.V775TdcMode=%d\n",VMEParameter.V775TdcMode[j]);
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
      //g_print ("Offset=0x%4X, Data=0x%4X\n",Offset,Data);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1032,&Data,cvA32_U_DATA,2);
      InterpretVmeRet(Ret);
      if (VMEParameter.V775TdcFullRange[j]==1200)     Data=31;
      else if (VMEParameter.V775TdcFullRange[j]==1100) Data=35;
      else if (VMEParameter.V775TdcFullRange[j]==1000) Data=39;
      else if (VMEParameter.V775TdcFullRange[j]==900)  Data=44;
      else if (VMEParameter.V775TdcFullRange[j]==800)  Data=50;
      else if (VMEParameter.V775TdcFullRange[j]==700)  Data=58;
      else if (VMEParameter.V775TdcFullRange[j]==600)  Data=68;
      else if (VMEParameter.V775TdcFullRange[j]==500)  Data=82;
      else if (VMEParameter.V775TdcFullRange[j]==400)  Data=103;
      else if (VMEParameter.V775TdcFullRange[j]==300)  Data=139;
      else if (VMEParameter.V775TdcFullRange[j]==200)  Data=215;
      else                                             Data=255;
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+0x1060,&Data,cvA32_U_DATA,2);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+0x1060,&Data,cvA32_U_DATA,2);
      //g_print ("Data after V775TdcFullRange setting=0x%4X\n",Data);
      InterpretVmeRet(Ret);                                                                       //TDC Full range setup
      }
   }
   //....Setting up Iped register of CAEN VME QDC V862 for pedestal correction
for (j=0;j<NoOfModules;j++)                                                                        //CAEN V775 TDC setup
   {
   if ((VMEParameter.ModuleType[j]==3))
      {
      //g_print("VMEParameter.ModuleType[%d]=%d\n",j, VMEParameter.ModuleType[j]);
      Data=VMEParameter.V862Pedestal[j];
      Offset=0x1060;
      Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
      CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[j]+Offset,&Data,cvA32_U_DATA,2);
      //g_print ("Pedestal set as =%d \n",Data);
      InterpretVmeRet(Ret);
      }
   }
Data=0x1;                                                                              //Interrupt level 1 for first ADC
Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[0]+0x100A,&Data,cvA32_U_DATA,2);
InterpretVmeRet(Ret);
//CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[0]+0x100A,&Data,cvA32_U_DATA,2);
//g_print("Interrupt level set as %d for first module\n",Data&0x7);
Data=0x1;                                                                             //Interrupt Vector 1 for first ADC
Ret=CAENVME_WriteCycle(BHandle,VMEParameter.BaseAddress[0]+0x100C,&Data,cvA32_U_DATA,2);
InterpretVmeRet(Ret);
//CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[0]+0x100C,&Data,cvA32_U_DATA,2);
//g_print("Interrupt vector set as %d for first module\n",Data&0xFF);

//.........Setting ADC's in Offline mode, Event counter reset, Data Reset and setting ADC's back to Online mode.........
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=0x2;                                 //To set ADC's in offline mode
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,
                          NoOfModules*2,0x09,2,&BytesRead);
//InterpretVmeRet(Ret);
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=1<<12;                //To set EMPTY PROG bit in bit set 2 register
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,
                          NoOfModules*2,0x09,2,&BytesRead);
//InterpretVmeRet(Ret);                   //Header and EOB written into the output buffer even if there is no valid data
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=1<<3;                                 //Overrange checking disabled
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,
                          NoOfModules*2,0x09,2,&BytesRead);
InterpretVmeRet(Ret);
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=0xFF;
                                              //Dummy write with any data to 0x1040 is sufficient to reset event counter
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1040,&VMEParameter.McstBuff,
                          NoOfModules*2,0x09,2,&BytesRead);
//InterpretVmeRet(Ret);
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=0x4;                                               //For data reset
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,
                          NoOfModules*2,0x09,2,&BytesRead);
usleep(100000);                                                                 //Seems to be very important for the TDC
//InterpretVmeRet(Ret);
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=0x4;      //Changing the module from permanent data reset to normal
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1034,&VMEParameter.McstBuff,
                          NoOfModules*2,0x09,2,&BytesRead);
//InterpretVmeRet(Ret);
// .......................... Data Reset completed ............................
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=0x2;                             //To set ADC's back to online mode
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1034,&VMEParameter.McstBuff,
                          NoOfModules*2,0x09,2,&BytesRead);
//InterpretVmeRet(Ret);

if (Setup.Scaler.NSc>0)                                                              //Check whether a scalar is present
   {
   for (j=0;j<VMEParameter.NoOfScalerModules;j++)
      {
      Data=0xFFFF;     //V830 scaler Data Reset
      CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1122,&Data,cvA32_U_DATA,cvD16);
                                                                                     //Clears MEB, Counter Registers etc
      }
   }

for (i=0;i<NPar1;++i)
   {
   ParaNo[GeoAddr[i]][Setup.Parameter.A[i]]=i+1;
   /*g_print("Parameter No=%d,Geo=%d,Setup.Parameter.A=%d,Setup.Parameter.N=%d,Setup.Parameter.BaseAddr=0x%08X\n",
              ParaNo[GeoAddr[i]][Setup.Parameter.A[i]], GeoAddr[i], Setup.Parameter.A[i],Setup.Parameter.N[i],
              Setup.Parameter.BaseAddr[i]);*/
   }
VMEParameter.AddressMode=cvA32_U_BLT;
DataWidth=4; VMEParameter.DataWidth=DataWidth; //g_print("Data width=%u\n",DataWidth*8);
EvtSize=NPar1; //NoOfModules*32;
}
//----------------------------------------------------------------------------------------------------------------------
void CheckDataReady(int32_t BHandle,gboolean *DataReady,gint i)
{
guint32 Data;
gint Id;

CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[i]+0x100E,&Data,cvA32_U_DATA,2);
if (Data&1) *DataReady=TRUE;
else *DataReady=FALSE;
//if (!(*DataReady)) g_print("Data=%03X DataReady=%d\n",0x1FF&Data,*DataReady);
}
//----------------------------------------------------------------------------------------------------------------------
int VMEReadCycle(int32_t BHandle,gushort *AcqBuf,guint32 *ScalerBuf)
{
guint32 Offset,DataWidth,BaseAddr,Data,GeoAddress,ValidChannels;
const gchar *OffsetHex,*AddressWidth,*BaseAddrHex;
CVBoardTypes  VMEBoard;
CVErrorCodes    Ret;
gint i,Id,NEvts,BufSize,EvtNo,Module,CumSubAddr,k,NEvtsObtained,NoOfWords,j,jprev;
gushort A,D;
gboolean DataReady;
struct timeval Tv;
gdouble CurrentTime,EndTime;

for(i=0;i<65535;i++) AcqBuf[i]=0;
NEvts=Setup.ListMode.BufSiz/2/Setup.Parameter.NPar;
/*g_print("Setup.ListMode.BufSiz=%d,Setup.Parameter.NPar=%d,NEvts=%d\n",Setup.ListMode.BufSiz,
          Setup.Parameter.NPar,NEvts);*/
NEvtsObtained=0;                                                                                 //Read operation starts
for (EvtNo=0;EvtNo<NEvts;++EvtNo)
    {
    for (i=0;i<NoOfModules;i++)
        {
        DataReady=FALSE;
        while (DataReady==FALSE)
              {
              CheckDataReady(BHandle,&DataReady,i);
              if (AcqSignal==Stop) break;
              }
        }
    if (AcqSignal==Stop) break;
    CumSubAddr=0;
    for (Module=0;Module<NoOfModules;++Module)
        {
        for (i=0;i<NoOfSubAddr[Module]+2;++i)                      //This will work for 32 channel digitization modules
            {
            gettimeofday(&Tv,NULL); CurrentTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
            //g_print("Current time at the end of data ready =%lf \n",CurrentTime);
            Ret=CAENVME_ReadCycle(BHandle,VMEParameter.Address[Module],&Data,VMEParameter.AddressMode,
                                  VMEParameter.DataWidth);
            gettimeofday(&Tv,NULL); EndTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
            //g_print("Time @ end of CBLT read cycle for CAEN Modules =%lf \n",EndTime);
            //g_print("Time Difference b/w code fragments=%lf \n", EndTime-CurrentTime);
            /*g_print("Address=%08X Data=%u Am=%d DWidth=%d Ret=%d\n",VMEParameter.Address[Module],Data&0x1fff,
                      VMEParameter.AddressMode,VMEParameter.DataWidth,Ret);*/
            switch (Ret)                                                                                 //Data printing
               {
               case cvSuccess: //g_print(" Cycle completed normally\n");
                 if (VMEParameter.DataWidth == cvD32)
                    {
                    Id=(Data>>24)&7;                                               //Will work with CAEM ADC,TDC and QDC
                    //g_print("Data Read : %08X, Id=%d\n",Data,Id);
                    switch (Id)
                       {
                       case 0:
                          A=(Data>>16)&0x1F; D=Data&0x0FFF; //g_print("i=%d A=%d Data=%d\n",i,A,D);
                                                                                          //Id is 000 for digitized data
                          //AcqBuf[EvtSize*EvtNo+Module*32+A]=D;
                          for (k=0;k<NoOfSubAddr[Module];++k)
                             {
                             if (A==Setup.Parameter.A[CumSubAddr+k])
                                {
                                AcqBuf[EvtSize*EvtNo+CumSubAddr+k]=D;
                                /*g_print("EvtNo=%d,Module=%d,i=%d,k=%d,A=%d\n",EvtNo,Module,i,k,A);
                                g_print("Setup.Parameter.A[CumSubAddr+k]=%d,CumSubAddr=%d,NoOfSubAddr[Module]=%d\n",
                                         Setup.Parameter.A[CumSubAddr+k],CumSubAddr,NoOfSubAddr[Module]);
                                g_print("Data=%d,EvtSize*EvtNo+CumSubAddr+k=%d\n",D,EvtSize*EvtNo+CumSubAddr+k);*/
                                }
                             }
                          break;
                       case 2: ValidChannels=(Data>>8)&0x4F;                                               //Header word
                               //g_print("i=%d Header found. Valid Channels=%u\n",i,ValidChannels);
                               break;
                       case 4: /*g_print("i=%d Event Number=%d\n",i,Data&0xFFFFFF);*/ 
                               break;                                        //End of Block word containing event number
                       default: g_print("Invalid readout!!! Id=%d, Module=%d, i=%d\n",Id,Module,i); break;
                       }
                    }
                 if (VMEParameter.DataWidth == cvD16) g_print("Data Read: %04X\n",Data&0xffff);
                 if (VMEParameter.DataWidth == cvD8 ) g_print("Data Read: %02X\n",Data&0xff);
                 break;
               case cvBusError  : g_print("Bus Error!\n"); break;
               case cvCommError : g_print("Communication Error!\n"); break;
               default          : g_print("Unknown Error!\n"); break;
               }
            //g_print("i=%d, ValidChannels=%u \n",i,ValidChannels);
            if (i>=(ValidChannels+1)) break;
            }
        CumSubAddr=CumSubAddr+NoOfSubAddr[Module];
        }
    ++NEvtsObtained;
    }
//g_print("NEvtsObtained=%d, EvtSize=%d\n",NEvtsObtained,EvtSize);

   if (Setup.Scaler.NSc>0)
      {
      Data=0xFFFF;
      for (j=0;j<VMEParameter.NoOfScalerModules;j++)
          CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[j]+0x1124,&Data,cvA32_U_DATA,cvD16);
      }

//Read Scaler in single cycle Mode when only one scaler is present.
if (VMEParameter.NoOfScalerModules>=1)
    {
    usleep(1); //It takes 1 micro-second for data to be written from counters to MEB
    i=0; jprev=0;
    while (i<(Setup.Scaler.NSc+VMEParameter.NoOfScalerModules))
          {
          for (k=0;k<VMEParameter.NoOfScalerModules;k++)
              {
              CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[k],&VMEParameter.Buff[i],cvA32_U_DATA,cvD32);
              GeoAddress=((VMEParameter.Buff[i])>>27)&0x1F; //g_print("GeoAddress=%u\n",GeoAddress);
              NoOfWords=((VMEParameter.Buff[i])>>18)&0x3F; //g_print("No of enabled channels in module=%u\n",NoOfWords);
              i++;
              for (j=0;j<NoOfWords;j++)
                  {
                  CAENVME_ReadCycle(BHandle,VMEParameter.ScalerBaseAddress[k],&VMEParameter.Buff[i],cvA32_U_DATA,cvD32);
                  ScalerBuf[j+jprev]=VMEParameter.Buff[i]; //g_print("ScalerBuf=%u \n",ScalerBuf[j]);
                  i++;
                  }
              jprev+=j;
              }
          }
    //for (i=0;i<Setup.Scaler.NSc;i++) g_print("ScalerBuf[i=%d]=%u \n",i,ScalerBuf[i]);
    }
BufSize=NEvtsObtained*EvtSize*2;
//g_print("Data=%d,%d,%d,%d,%d,%d,%d\n",AcqBuf[0],AcqBuf[1],AcqBuf[2],AcqBuf[3],AcqBuf[4],AcqBuf[5],AcqBuf[6]);
return BufSize;
}
//----------------------------------------------------------------------------------------------------------------------
void DataReset(int32_t BHandle)
{
gint j,Ret;
guint32 BytesRead;

//...Setting ADC's in Offline mode, Event counter reset, Data Reset and setting ADC's back to Online mode....
for (j=0;j<NoOfModules;j++)
   if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))
      VMEParameter.McstBuff[j]=0x2;                                                           //Set ADCs in offline mode
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)
   //if (VMEParameter.ModuleType[j]==4)
   VMEParameter.McstBuff[j]=0x0;                                                     //Stop Acquisition for mesytec MADC
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x603A,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++) 
   //if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))
   VMEParameter.McstBuff[j]=0xFF;                           //Dummy write to 0x1040 is sufficient to reset event counter
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1040,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)
   //if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))
   VMEParameter.McstBuff[j]=0x4;                                                                        //For data reset
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
if (NoOfCAENDigitizerModule>=0) usleep(100000);                                 //Seems to be very important for the TDC
for (j=0;j<NoOfModules;j++)
   //if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))
   VMEParameter.McstBuff[j]=0x4;                               //Changing the module from permanent data reset to normal
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1034,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)  VMEParameter.McstBuff[j]=0x1;                             //Reset counters for mesytec MADC
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x6090,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)
   //if (VMEParameter.ModuleType[j]==4)
   VMEParameter.McstBuff[j]=0x0;                                                //For data (fifo) reset for mesytec MADC
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x603C,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)
   /*if (VMEParameter.ModuleType[j]==4)*/
   VMEParameter.McstBuff[j]=0x0;                                                    //For readout reset for mesytec MADC
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x6034,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
// .......................... Data Reset completed ............................
for (j=0;j<NoOfModules;j++)
   //if ((VMEParameter.ModuleType[j]>=1)||(VMEParameter.ModuleType[j]<=3))
   VMEParameter.McstBuff[j]=0x2;                                                      //To set ADC's back to online mode
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1034,&VMEParameter.McstBuff,NoOfCAENDigitizerModule*2,
                          cvA32_U_DATA,cvD16,&BytesRead);
for (j=0;j<NoOfModules;j++)
   //if (VMEParameter.ModuleType[j]==4)
   VMEParameter.McstBuff[j]=0x1;                                          //To start acquisition in Mesytec MADC modules
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x603A,&VMEParameter.McstBuff,
                          NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD16,&BytesRead);
//InterpretVmeRet(Ret);
}
//----------------------------------------------------------------------------------------------------------------------
void CheckBusy(int32_t BHandle,gboolean *Busy)
{
guint32 Data;
CVErrorCodes Ret;

if (VMEParameter.ModuleType[0]<4)
   {
   Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[0]+0x100E,&Data,cvA32_U_DATA,cvD16);
                                                                        //Read status register 1 for Busy status (bit=3)
   if ( (Ret==cvSuccess) && (((0x4&Data)>>2) || ((0x8&Data)>>3))) *Busy=TRUE;
   else *Busy=FALSE;
   }
else
   {
   //Program similarly for Mesytec. To be done in the future
   }
}
//----------------------------------------------------------------------------------------------------------------------
void CheckEvtReady(int32_t BHandle,gboolean *EvtReady)
{
guint32 Data,Data1;
gint Id;
CVErrorCodes Ret;

if (VMEParameter.ModuleType[0]<4)
   {
   Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[0]+0x100E,&Data,cvA32_U_DATA,cvD16);
                                    //Read status register 1 for Event ready (value greater than Event trigger register)
   if ( (Ret==cvSuccess) && ((0x1FF&Data)>>8) )
      {
      *EvtReady=TRUE;             //If events in the buffer is more than Event trigger register then Event Ready is true
      }
   else
      {
      Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[0]+0x1022,&Data1,cvA32_U_DATA,cvD16);
                                                                 //Read status register 2 to check buffer full condition
      if ( (Ret==cvSuccess) && ((0x7&Data1)>>2) )
         {
         *EvtReady=TRUE;                                           //If the buffer is full then also Event Ready is true
         g_print("Buffer full but Event Ready condition not true in status register 1! Please consult DAQ group\n");
         }
      else
         {
         Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[0]+0x100E,&Data,cvA32_U_DATA,cvD16);
         //g_print("Data=0x%03X\n",0x1FF&Data);
         if ((0x3&Data==3)) { *EvtReady=TRUE;usleep(5); /*g_print("DataReady is true!!!\n");*/ }
         else *EvtReady=FALSE;
         }
       }
   }
else if ((VMEParameter.ModuleType[0]==4)||(VMEParameter.ModuleType[0]==5))
   {
   Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[0]+0x6030,&Data,cvA32_U_DATA,cvD16);
                                 //Read Buffer Data Length register - Indicates amount of fully converted events in FIFO
   //InterpretVmeRet(Ret);
   if ((Ret==cvSuccess) && ((0xFFFF&Data)>=1)) 
      {
      *EvtReady=TRUE;
      /*g_print("Buffer Data Length in Module 2 =%d \t",Data&0xFFFF);
      Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[1]+0x6030,&Data,cvA32_U_DATA,cvD16); 
      g_print(" Amount of Data in FIFO in Module 1 =%d \n",0xFFFF&Data);*/
      }
   else { *EvtReady=FALSE; /*g_print("Reached 1...  Ret=%d EvtReady=%d\n",Ret,*EvtReady);*/ }
   }
else g_print("Error: Module Type Unknown....\n");
//if (*EvtReady) g_print("Data=0x%03X EvtReady=%d\n",0x1FF&Data,*EvtReady);
}
//----------------------------------------------------------------------------------------------------------------------
int VMEReadCBLT(int32_t BHandle,gushort *AcqBuf,guint32 *ScalerBuf)
{
guint32 Offset,DataWidth,BaseAddr,Data,Leng,BytesRead,GeoAddress,BytesWritten;
const gchar *OffsetHex,*AddressWidth,*BaseAddrHex;
int us;
CVBoardTypes  VMEBoard;
CVErrorCodes    Ret;
gint i,j,k,Id,NEvts,BufSize,EvtNo,Module,NEvtsObtained,CBLTCycle,WordsPerEvent,NoOfWords,jprev,NRp,BuffPtr;
gushort A,D;
gboolean EvtReady,Busy,ResetRequired;
struct timeval Tv;
gdouble CurrentTime,EndTime;
guint32 TimeStamp[NoOfMesytecDigitizerModule];
gint TDiff, AbsTDiff;
gushort GeoA;
              
for(i=0;i<65535;i++) AcqBuf[i]=0;
NEvts=Setup.ListMode.BufSiz/2/Setup.Parameter.NPar;
/*g_print("Setup.ListMode.BufSiz=%d,Setup.Parameter.NPar=%d,NEvts=%d\n",Setup.ListMode.BufSiz,
          Setup.Parameter.NPar,NEvts);*/
NEvtsObtained=0;                                                                                 //Read operation starts
for (EvtNo=0;EvtNo<NEvts;++EvtNo)
   {
   //g_print("\tEvtNo=%d\n", EvtNo);
   EvtReady=FALSE;
   //g_print("Checking for Event ready Condition\n");
   while (EvtReady==FALSE)
      {
      CheckEvtReady(BHandle,&EvtReady);
      if (AcqSignal==Stop) break;
      if (EvtReady==FALSE)
         {
         gettimeofday(&Tv,NULL); CurrentTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
         //g_print("Current time at the start of CheckBusy Loop =%lf \n",CurrentTime);
         for (us=1;us<5;us++)
            {
            //CheckBusy(BHandle,&Busy);
            if (VMEParameter.ModuleType[0]<4)
               {
               Ret=CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[0]+0x100E,&Data,cvA32_U_DATA,cvD16);
                                                                        //Read status register 1 for Busy status (bit=3)
               if ( (Ret==cvSuccess) && (((0x4&Data)>>2) || ((0x8&Data)>>3))) Busy=TRUE;
               else Busy=FALSE;
              }
            else Busy=FALSE;                                                                                   //Crucial
            if (Busy==FALSE) break;
            else
               {
               usleep(1);
               if (AcqSignal==Stop) break;
               if (us>=2) 
                  {
                  //g_print("DAQ busy for %d microsecond continuously - Resetting!!!\n",us);
                  DataReset(BHandle);
                  //gettimeofday(&Tv,NULL); EndTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
                  //g_print("Time when continiously busy =%lf \n",EndTime);
                  //g_print("Time Difference b/w code fragments=%lf \n", EndTime-CurrentTime);
                  break; //Come out of the For loop
                  }
               }
            CheckEvtReady(BHandle,&EvtReady);
            if (EvtReady==TRUE) break;
            }                                                                                       //End of For us loop
         }                                                                        //End of If Eventready=FALSE condition
      }                                                                                         //End of While Condition
   if (AcqSignal==Stop) break;

   if ( ( (Setup.Scaler.NSc>0)&&(EvtNo==NEvts-1) ) || ((Setup.Scaler.NSc>0)&&(AcqSignal==Stop)) )
      {
      Data=0xFFFF; //g_print("x=%d \n",x);
      if (VMEParameter.NoOfScalerModules==1)
         CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[0]+0x1124,&Data,cvA32_U_DATA,cvD16);
      else
         {
         for (j=0;j<VMEParameter.NoOfScalerModules;j++) VMEParameter.McstBuff[j]=0xFFFF;   //Not yet tested in MCST mode
         Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.ScalerCBLTBaseAddress+0x1124,&VMEParameter.McstBuff,
                                   VMEParameter.NoOfScalerModules*2,cvA32_U_DATA,cvD16,&BytesWritten);
         }
      }

   WordsPerEvent=Setup.Parameter.NPar+(2*NoOfModules); //g_print("Words Per Evt=%d\n",WordsPerEvent);
   if (VMEParameter.ModuleType[0]<4)                                                  //CBLT Block Read for CAEN Modules
      {
      for (NRp=0,BytesRead=0,BuffPtr=0;NRp<MAX_VME_STNS;++NRp)        //Fix-> Looping over max_vme_station isn't correct 
         {
         //gettimeofday(&Tv,NULL); CurrentTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
         //g_print("Current time at the end of data ready =%lf \n",CurrentTime);
         Ret=CAENVME_BLTReadCycle(BHandle,VMEParameter.CBLTBaseAddress,&VMEParameter.Buff[BuffPtr],255,
                                  VMEParameter.AddressMode,VMEParameter.DataWidth,&Leng);
         //gettimeofday(&Tv,NULL); EndTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
         //g_print("Time @ end of CBLT read cycle for CAEN Modules =%lf \n",EndTime);
         //g_print("Time Difference b/w code fragments=%lf \n", EndTime-CurrentTime);
         BytesRead+=Leng; BuffPtr+=Leng>>2;
         if (Ret==cvBusError) { BytesRead-=4; break; }
         }
      for (i=0;i<BytesRead/4;++i)
         {
         if (VMEParameter.DataWidth == cvD32)
            {
            GeoAddress=((VMEParameter.Buff[i])>>27)&0x1F;
            Id=(VMEParameter.Buff[i]>>24)&7;                                       //Will work with CAEN ADC,TDC and QDC
            //g_print("GeoAddr=%d, Data Read : %08X, Id=%d\n",GeoAddress,VMEParameter.Buff[i],Id);
            //g_print("Geo=%d, VersionChoice= %d\n",GeoAddress, VMEParameter.VersionChoice[GeoAddress-1]);     
            switch (Id)
               {
               case 0: if (!VMEParameter.VersionChoice[GeoAddress-1]) A=(VMEParameter.Buff[i]>>16)&0x1F; 
                       else A=(VMEParameter.Buff[i]>>17)&0xF;
                       D=VMEParameter.Buff[i]&0x0FFF;                                     //Id is 000 for digitized data
                       /*g_print("i=%d A=%d VMEParameter.Buff[i]=%d,VersionChoice= %d\n",
                                 i,A,D,VMEParameter.VersionChoice[GeoAddress-1]);*/ 
                       AcqBuf[EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1]=D;
                       /*g_print("EvtSize=%d, EvtNo=%d, Index=%d, GeoAddress=%d, A=%d, Data=%d\n",
                                 EvtSize,EvtNo,EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1,GeoAddress,A,D);*/
                       break;
               case 2: /*g_print("header word\n");*/ break;                                                //Header word
               case 4: /*g_print("EOB\n");*/ break;                          //End of Block word containing event number
                     default: g_print("Invalid readout!!! Id=%d\n",Id); break;
                     }
                  }
               }

      if (NoOfMesytecDigitizerModule!=0)
         {
         for (j=NoOfCAENDigitizerModule;j<NoOfModules;j++) 
            {
            Ret=CAENVME_BLTReadCycle(BHandle,VMEParameter.BaseAddress[j],&VMEParameter.Buff,255,cvA32_U_BLT,cvD32,&BytesRead);
            GeoAddress=((VMEParameter.Buff[0])>>16)&0xFF;
            for (i=0;i<BytesRead/4;++i)
               {
               if (VMEParameter.DataWidth == cvD32)
                  {
                  Id=(VMEParameter.Buff[i]>>30)&3;
                  //g_print("GeoAddr=%d, Data Read : %08X, Id=%d\t",GeoAddress,VMEParameter.Buff[i],Id);
                  switch (Id)
                     {
                     case 0: 
                     if (!((VMEParameter.Buff[i]>>21)&0x1))
                                              //Checking for trigger flag in Mesytec TDC where Trigger is also digitized
                                                                                     //We don't need the trigger in data
                        {
                        A=(VMEParameter.Buff[i]>>16)&0x1F; D=VMEParameter.Buff[i]&0x1FFF;
                        //g_print("i=%d A=%d Masked Data=%d, Raw Data=%X\t",i,A,D,VMEParameter.Buff[i]);
                                                                                            //Id is 0 for digitized data
                        AcqBuf[EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1]=D;
                        /*g_print("EvtNo=%d, Index=%d, GeoAddress=%d, A=%d, Data=%d\n",EvtNo,
                                  EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1,GeoAddress,A,D);*/
                                                        }
                        break;
                        case 1:  //GeoAddress=(VMEParameter.Buff[i]>>16)&0xFF; 
                                 //printf(" Header word from Geo Addr=%d\n",GeoAddress);
                                 break;                                                                    //Header word
                        case 3:  /*g_print("EOB, Event number=%u\n",VMEParameter.Buff[i]&0x3FFFFFFF);*/
                                 break;                                      //End of Block word containing event number
                        default: g_print("Invalid readout!!! Id=%d\n",Id); break;
                        }
                     }
                  }
               }
            }
      for (j=0;j<NoOfMesytecDigitizerModule;j++) VMEParameter.McstBuff[j]=0x0;
      CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x6034,&VMEParameter.McstBuff,
                            NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD32,&BytesRead);
      }                                                                           //End CBLT Block Read for CAEN Modules
   else
      {
      for (j=0;j<(NoOfMesytecDigitizerModule+7)/7;j++)                       //Fix -> Change to looping over CBLT Cycles 
         {
         Ret=CAENVME_BLTReadCycle(BHandle,/*VMEParameter.BaseAddress[j]*/VMEParameter.CBLTBaseAddress,
                                  &VMEParameter.Buff,255,cvA32_U_BLT,cvD32,&BytesRead);
         for (i=0;i<BytesRead/4;++i)
            {
            if (VMEParameter.DataWidth == cvD32)
               {
               Id=(VMEParameter.Buff[i]>>30)&3;
               if (Id==1) GeoAddress=((VMEParameter.Buff[i]>>16)&(0xFF));
               //g_print("\t\tData Read : %08X, Id=%d\n",VMEParameter.Buff[i],Id);
               switch (Id)
                  {
                  case 0: if ((!((VMEParameter.Buff[i]>>21)&0x1))&&(VMEParameter.Buff[i]!=0))
                                              //Checking for trigger flag in Mesytec TDC where trigger is also digitized
                                                                                     //We don't need the trigger in data
                             {
                             A=(VMEParameter.Buff[i]>>16)&0x1F;
                             D=VMEParameter.Buff[i]&(VMEParameter.AdcGain[GeoAddress-1]-1);
                             //A=(VMEParameter.Buff[i]>>16)&0x1F; D=VMEParameter.Buff[i]&65535;
                             /*g_print("GeoAddress=%d,VMEParameter.AdcGain[GeoAddress]=%d\n",GeoAddress,
                                        VMEParameter.AdcGain[GeoAddress-1]);*/
                             /*if (D==24064)
                                  g_print("i=%d A=%d Masked Data=%d, Raw Data=%X\n",i,A,D,
                                          (VMEParameter.Buff[i]&65535));*/
                                                                                            //Id is 0 for digitized data
                             AcqBuf[EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1]=D;
                             /*g_print("EvtNo=%d, Index=%d, A=%d, Data=%d\n",EvtNo,
                                       EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1,A,D);*/
                             /*if (D==24064)
                                  g_print("EvtNo=%d, Index=%d, A=%d, Data=%d\n",EvtNo,
                                          EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1,A,D);*/
                             }   
                             else
                             {
                             //g_print("Trigger word in GeoAddress=%d \n",GeoAddress);
                             }
                          break;
                  case 1: /*GeoAddress=(VMEParameter.Buff[i]>>16)&0xFF;
                          printf(" Header word from Geo Addr=%d\n",GeoAddress); */ 
                          break;                                                                           //Header word
                  case 3: TimeStamp[GeoAddress]=VMEParameter.Buff[i]&0x3FFFFFFF;
                          //g_print("\t Time Stamp/Event number=%u\n",VMEParameter.Buff[i]&0x3FFFFFFF);
                          break;                                             //End of Block word containing event number
                  case 2: g_print("End of Buffer marker word\n");
                          break;                                                                    //End of Buffer word
                  default: g_print("Invalid readout!!! Id=%d\n",Id); break;
                  }
               }
            }
         }
      for (j=0;j<NoOfMesytecDigitizerModule;j++) VMEParameter.McstBuff[j]=0x0;
      Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.MCSTBaseAddress+0x6034,&VMEParameter.McstBuff,
                                NoOfMesytecDigitizerModule*2,cvA32_U_DATA,cvD32,&BytesRead);
      if (NoOfCAENDigitizerModule!=0)
         {
         for (CBLTCycle=0;CBLTCycle<(((NoOfCAENParameters+2*NoOfCAENDigitizerModule)/256)+1);++CBLTCycle)
            {
            VMEParameter.BltSize=((NoOfCAENParameters+2*NoOfCAENDigitizerModule))*4;
            Ret=CAENVME_BLTReadCycle(BHandle,VMEParameter.CBLTBaseAddress,&VMEParameter.Buff,VMEParameter.BltSize,
                                     VMEParameter.AddressMode,VMEParameter.DataWidth,&BytesRead);
            for (i=0;i<BytesRead/4;++i)
               {
               if (VMEParameter.DataWidth == cvD32)
                  {
                  GeoAddress=((VMEParameter.Buff[i])>>27)&0x1F;
                  Id=(VMEParameter.Buff[i]>>24)&7;                                 //Will work with CAEN ADC,TDC and QDC
                  //g_print("GeoAddr=%d, Data Read : %08X, Id=%d\n",GeoAddress,VMEParameter.Buff[i],Id);
                  switch (Id)
                     {
                     case 0: A=(VMEParameter.Buff[i]>>16)&0x1F; D=VMEParameter.Buff[i]&0x0FFF;
                             //g_print("i=%d A=%d VMEParameter.Buff[i]=%d\n",i,A,D);      //Id is 000 for digitized data
                             AcqBuf[EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1]=D;
                             /*g_print("EvtSize=%d, EvtNo=%d, Index=%d, GeoAddress=%d, A=%d, Data=%d\n",EvtSize,EvtNo,
                                       EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1,GeoAddress,A,D);*/  
                             break;
                     case 2: /*g_print("header word\n");*/ break;                                          //Header word
                     case 4: /*g_print("EOB\n");*/ break;                    //End of Block word containing event number
                     default: g_print("Invalid readout!!! Id=%d\n",Id); break;
                     }
                  }
               }
            }                                                                                   //End of CBLT cycle loop
         }
      }
   ++NEvtsObtained;
   if ((NoOfMesytecDigitizerModule>=2) /*&& (EvtNo==1)*/)                         //Check for presence of Mesytec module
      {
      ResetRequired=FALSE;
      /*g_print("In timestamp comparison loop ..., TimeStamp[1]=%d, TimeStamp[2]=%d, TimeStamp[3]=%d\n",
                TimeStamp[1], TimeStamp[2], TimeStamp[3]);*/
      for (GeoA=2;GeoA<NoOfMesytecDigitizerModule;GeoA++)
         {
         TDiff=TimeStamp[GeoA-1]-TimeStamp[GeoA]; 
         //if (TDiff<0) {AbsTDiff=TDiff-(2*TDiff);}
         if (TDiff<0) {AbsTDiff=-TDiff;}
         else { AbsTDiff=TDiff; }
         /*g_print("TimeStamp[%d]=%d, TimeStamp[%d]=%d, Absolute Time Difference=%d \n",
                   GeoA,TimeStamp[GeoA],GeoA-1,TimeStamp[GeoA-1],AbsTDiff);*/
         if (AbsTDiff>10) {ResetRequired=TRUE; break;}
         }
      if (ResetRequired) 
         {
         DataReset(BHandle);
         /*g_print("Resetting Mesytec Modules due to timestamp mismatch=%d ns\n",AbsTDiff*62);*/
         }
      }
   }                                                                                                 //End of EvtNo loop
//g_print("NEvtsObtained=%d, EvtSize=%d\n",NEvtsObtained,EvtSize);

//Read Scaler in BLT Mode when only one scaler is present.
if (VMEParameter.NoOfScalerModules>=1)
   {
   usleep(1); //It takes 1 micro-second for data to be written from counters to MEB
   if (VMEParameter.NoOfScalerModules==1)
      {
      //g_print("VMEParameter.ScalerBaseAddress=0x%08X\n",VMEParameter.ScalerBaseAddress[0]);
      CAENVME_BLTReadCycle(BHandle,VMEParameter.ScalerBaseAddress[0],&VMEParameter.Buff,
                           (Setup.Scaler.NSc+VMEParameter.NoOfScalerModules+1)*4,cvA32_U_DATA,cvD32,&BytesRead);
      for (i=0;i<BytesRead/4;++i)
         {
         /*if (VMEParameter.Buff[i]>=0) 
              g_print("i=%d Data=0x%8X, BltSize=%d bytes, BytesRead= %d\n",i,VMEParameter.Buff[i],
                      (Setup.Scaler.NSc+VMEParameter.NoOfScalerModules+1)*4,BytesRead);*/
         }
      }
   //Read Scaler in CBLT Mode when more than one scaler is present. Code is not complete for the commented portion
   else if (VMEParameter.NoOfScalerModules>1)
      {
      //g_print("VMEParameter.ScalerCBLTBaseAddress=0x%08X\n",VMEParameter.ScalerCBLTBaseAddress);
      CAENVME_BLTReadCycle(BHandle,VMEParameter.ScalerCBLTBaseAddress,&VMEParameter.Buff,
                           (Setup.Scaler.NSc+VMEParameter.NoOfScalerModules+1)*4,cvA32_U_DATA,cvD32,&BytesRead);
      for (i=0;i<BytesRead/4;++i)
         {
         /*if (VMEParameter.Buff[i]>=0)
         g_print("i=%d Data=0x%8X, BltSize=%d bytes, BytesRead= %d\n",
                 i,VMEParameter.Buff[i],(Setup.Scaler.NSc+VMEParameter.NoOfScalerModules+1)*4,BytesRead);*/
         }
      }
   i=0; jprev=0;
   while (i<BytesRead/4)
      {
      for (k=0;k<VMEParameter.NoOfScalerModules;k++)
         {
         GeoAddress=((VMEParameter.Buff[i])>>27)&0x1F; //g_print("GeoAddress=%u \n",GeoAddress);
         NoOfWords=((VMEParameter.Buff[i])>>18)&0x3F; //g_print("No of enabled channels in module=%u \n",NoOfWords);
         i++;
         for (j=0;j<NoOfWords;j++)
            {
            ScalerBuf[j+jprev]=VMEParameter.Buff[i]; //g_print("ScalerBuf=%u \n",ScalerBuf[j]);
            i++;
            }
         jprev+=j;
         }
      }
   //for (i=0;i<Setup.Scaler.NSc;i++) g_print("ScalerBuf[i=%d]=%u \n",i,ScalerBuf[i]);
   }
BufSize=NEvtsObtained*EvtSize*2;
//for (k=0;k<NEvtsObtained*EvtSize;++k) {if (AcqBuf[k]==7680) g_print("k=%d, Data=%d\n",k, AcqBuf[k]);}
//for (k=0;k<NEvtsObtained*EvtSize;++k) g_print("k=%d, Data=%d\n",k, AcqBuf[k]);
//g_print("Reached end of ReadCBLT function\n");

return BufSize;
}
//----------------------------------------------------------------------------------------------------------------------
int VMEInterruptReadCBLT(int32_t BHandle,gushort *AcqBuf,guint32 *ScalerBuf)
{
guint32 Offset,DataWidth,BaseAddr,Data,BytesRead,GeoAddress,BytesWritten;
const gchar *OffsetHex,*AddressWidth,*BaseAddrHex;
CVBoardTypes  VMEBoard;
CVErrorCodes    Ret;
gint i,j,k,Id,NEvts,BufSize,EvtNo,Module,CBLTCycle,WordsPerEvent,StatusId,x,y,NoOfWords,jprev,OverFlow;
gushort A,D;
guchar IRQLevel;
gboolean EvtReady,Status_ETR;                                                             //ETR - Event Trigger Register

NEvts=Setup.ListMode.BufSiz/2/Setup.Parameter.NPar;
/*g_print("Setup.ListMode.BufSiz=%d,Setup.Parameter.NPar=%d,NEvts=%d\n",
          Setup.ListMode.BufSiz,Setup.Parameter.NPar,NEvts);*/
WordsPerEvent=Setup.Parameter.NPar+(2*NoOfModules); //g_print("Words Per Evt=%d\n",WordsPerEvent);
for (x=0,EvtNo=0;x<NEvts/EVT_TRG_REG;++x)                                                        //Read operation starts
   {
   Status_ETR=FALSE;
   CAENVME_IRQEnable(BHandle,cvIRQ1);
   do
      {
      Ret=CAENVME_IRQWait(BHandle,cvIRQ1,50); //Wait is in milliseconds
      //if (Ret!=0) g_print("IRQ wait Error Type=%d \n", Ret);
      if (AcqSignal==Stop) break;
      if (Ret==cvTimeoutError)
         {
         //g_print("IRQ timed out \n");
         CAENVME_ReadCycle(BHandle,VMEParameter.BaseAddress[0]+0x100E,&Data,cvA32_U_DATA,2);
         if (((Data>>8)&1)==1)
            {
            /*g_print("Events stored in memory >= the number set in the Event Trigger Register.\n");
              g_print("(Interrupt request generated)\n");*/
            Status_ETR=TRUE;
            break;
            }
         }
      else CAENVME_IRQCheck(BHandle,&IRQLevel);
      }
   while ((Ret==cvTimeoutError)||((IRQLevel&0xFF)!=0x1));
   //g_print("Status_ETR after breaking out of loop=%d\n",Status_ETR);
   CAENVME_IRQDisable(BHandle,cvIRQ1);
   CAENVME_IACKCycle(BHandle,cvIRQ1,&StatusId,2);

   //Generating Trigger for copying data to MEB from counters
   if ( ( (Setup.Scaler.NSc>0)&&(x==(NEvts/EVT_TRG_REG)-1) ) || ((Setup.Scaler.NSc>0)&&(AcqSignal==Stop)) )
      {
      Data=0xFFFF; //g_print("x=%d \n",x);
      if (VMEParameter.NoOfScalerModules==1)
         CAENVME_WriteCycle(BHandle,VMEParameter.ScalerBaseAddress[0]+0x1124,&Data,cvA32_U_DATA,cvD16);
      else
         {
         for (j=0;j<VMEParameter.NoOfScalerModules;j++) VMEParameter.McstBuff[j]=0xFFFF;   //Not yet tested in MCST mode
         Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.ScalerCBLTBaseAddress+0x1124,&VMEParameter.McstBuff,
                                   VMEParameter.NoOfScalerModules*2,cvA32_U_DATA,cvD16,&BytesWritten);
         //InterpretVmeRet(Ret);
         }
      }

   if (((StatusId&0xFF)==0x1)||(Status_ETR==TRUE)||(AcqSignal==Stop))
      {
      for (y=0;y<EVT_TRG_REG;++y)
         {
         //g_print("EvtNo=%d \n",EvtNo);
         for (CBLTCycle=0;CBLTCycle<((WordsPerEvent/256)+1);++CBLTCycle)
            {
            VMEParameter.BltSize=(WordsPerEvent+1)*4;
            Ret=CAENVME_BLTReadCycle(BHandle,VMEParameter.CBLTBaseAddress,&VMEParameter.Buff,VMEParameter.BltSize,
                                     VMEParameter.AddressMode,VMEParameter.DataWidth,&BytesRead);
            /*
            InterpretVmeRet(Ret);
            for (i=0;i<BytesRead/4;i++) 
               if ((i==17)||(i==18)||(i==19)) g_print("VMEParameter.Buff[i=%d]=%d \n",i,VMEParameter.Buff[i]&0xFFF);
            for (j=0;j<BytesRead/4;++j)
                {
                if (j==72)
                   {
                   g_print("j=%d Address=%X Data=0x%08X Masked Data=%u\n",j,VMEParameter.CBLTBaseAddress,
                           VMEParameter.Buff[j],VMEParameter.Buff[j]&0x1fff);
                   g_print("Am=0x%02X DWidth=%d VMEParameter.BltSize=%d bytes, BytesRead=%d\n",
                           VMEParameter.AddressMode,VMEParameter.DataWidth,VMEParameter.BltSize,BytesRead);
                   }
                }
            for (j=0;j<BytesRead/4;++j)
               {
               g_print("j=%d Address=%X Data=0x%08X Masked Data=%u\n",j,VMEParameter.CBLTBaseAddress,
                       VMEParameter.Buff[j], VMEParameter.Buff[j]&0x1fff);
               g_print("Am=0x%02X DWidth=%d VMEParameter.BltSize=%d bytes, BytesRead= %d\n",
                       VMEParameter.AddressMode,VMEParameter.DataWidth,VMEParameter.BltSize, BytesRead);
            */
            for (i=0;i<BytesRead/4;++i)
               {
               if (VMEParameter.DataWidth == cvD32)
                  {
                  GeoAddress=((VMEParameter.Buff[i])>>27)&0x1F;
                  Id=(VMEParameter.Buff[i]>>24)&7;                                 //Will work with CAEN ADC,TDC and QDC
                  //g_print("GeoAddr=%d, Data Read : %08X, Id=%d\n",GeoAddr,VMEParameter.Buff[i],Id);
                  switch (Id)
                     {
                     case 0: A=(VMEParameter.Buff[i]>>16)&0x1F; D=VMEParameter.Buff[i]&0x0FFF;
                             OverFlow=(VMEParameter.Buff[i]>>12)&0x1;
                             //g_print("i=%d A=%d VMEParameter.Buff[i]=%d, OverFlow=%d\n",i,A,D,OverFlow);
                             //g_print("i=%d A=%d VMEParameter.Buff[i]=%d\n",i,A,D);  
                             AcqBuf[EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1]=D;           //Id is 000 for digitized data
                             /*g_print("EvtSize=%d, EvtNo=%d, Index=%d, GeoAddress=%d, A=%d, Data=%d\n",EvtSize,EvtNo,
                                       EvtSize*EvtNo+(ParaNo[GeoAddress][A])-1,GeoAddress,A,D);*/
                             break;
                     case 2: /*g_print("header word\n");*/ break;                                          //Header word
                     case 4: /*g_print("EOB\n");*/ break;                    //End of Block word containing event number
                     default: g_print("Invalid readout!!! from Geographical Address=%d Id=%d\n",GeoAddress,Id); 
                              break;
                     }
                  }
               if (VMEParameter.DataWidth == cvD16) g_print("Data Read : %04X \n",VMEParameter.Buff[i]&0xffff);
               if (VMEParameter.DataWidth == cvD8)  g_print("Data Read : %02X \n",VMEParameter.Buff[i]&0xff);
               }
            } //End of CBLT cycle loop
         if (BytesRead==0) break;
         ++EvtNo;
         //g_print("EvtNo=%d\n", EvtNo+BuffersAcquired*EVT_TRG_REG);
         }                                                                                               //End of y loop
      }
   if (AcqSignal==Stop) break;
   }                                                                                                     //End of x loop
//g_print("Events Obtained=%d, EvtSize=%d\n",EvtNo, EvtSize);

/*----------------------------------------------------------
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=0x4;                                               //For data reset
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1032,&VMEParameter.McstBuff,NoOfModules*2,
                          0x09,2,&BytesRead);
//InterpretVmeRet(Ret);
for (j=0;j<NoOfModules;j++) VMEParameter.McstBuff[j]=0x4;      //Changing the module from permanent data reset to normal
Ret=CAENVME_BLTWriteCycle(BHandle,VMEParameter.CBLTBaseAddress+0x1034,&VMEParameter.McstBuff,NoOfModules*2,
                          0x09,2,&BytesRead);
//InterpretVmeRet(Ret);
------------------------------------------------------------*/

//Read Scaler in BLT Mode when only one scaler is present.
if (VMEParameter.NoOfScalerModules>=1)
   {
   usleep(1);                                      //It takes 1 micro-second for data to be written from counters to MEB
   if (VMEParameter.NoOfScalerModules==1)
      {
      //g_print("VMEParameter.ScalerBaseAddress=0x%08X\n",VMEParameter.ScalerBaseAddress[0]);
      CAENVME_BLTReadCycle(BHandle,VMEParameter.ScalerBaseAddress[0],&VMEParameter.Buff,
                           (Setup.Scaler.NSc+VMEParameter.NoOfScalerModules+1)*4,cvA32_U_DATA,cvD32,&BytesRead);
      for (i=0;i<BytesRead/4;++i)
         {
         /*if (VMEParameter.Buff[i]>=0)
              g_print("i=%d Data=0x%8X, BltSize=%d bytes, BytesRead= %d\n",i,VMEParameter.Buff[i],
                      (Setup.Scaler.NSc+VMEParameter.NoOfScalerModules+1)*4,BytesRead);*/
         }
      }
   //Read Scaler in CBLT Mode when more than one scaler is present. Code is not complete for the commented portion
   else if (VMEParameter.NoOfScalerModules>1)
      {
      //g_print("VMEParameter.ScalerCBLTBaseAddress=0x%08X\n",VMEParameter.ScalerCBLTBaseAddress);
      CAENVME_BLTReadCycle(BHandle,VMEParameter.ScalerCBLTBaseAddress,&VMEParameter.Buff,(Setup.Scaler.NSc+VMEParameter.NoOfScalerModules+1)*4,cvA32_U_DATA,cvD32,&BytesRead);
      for (i=0;i<BytesRead/4;++i)
         {
         /*if (VMEParameter.Buff[i]>=0)
              g_print("i=%d Data=0x%8X, BltSize=%d bytes, BytesRead= %d\n",i,VMEParameter.Buff[i],
                      (Setup.Scaler.NSc+VMEParameter.NoOfScalerModules+1)*4,BytesRead);*/
         }
      }
   i=0; jprev=0;
   while (i<BytesRead/4)
      {
      for (k=0;k<VMEParameter.NoOfScalerModules;k++)
         {
         GeoAddress=((VMEParameter.Buff[i])>>27)&0x1F; //g_print("GeoAddress=%u \n",GeoAddress);
         NoOfWords=((VMEParameter.Buff[i])>>18)&0x3F; //g_print("No of enabled channels in module=%u \n",NoOfWords);
         i++;
         for (j=0;j<NoOfWords;j++)
            {
            ScalerBuf[j+jprev]=VMEParameter.Buff[i]; //g_print("ScalerBuf=%u \n",ScalerBuf[j]);
            i++;
            }
         jprev+=j;
         }
      }
   //for (i=0;i<Setup.Scaler.NSc;i++) g_print("ScalerBuf[i=%d]=%u \n",i,ScalerBuf[i]);
   }
BufSize=EvtNo*EvtSize*2;
//g_print("BufSize=%u \n",BufSize);
/*
for (i=0;i<Setup.ListMode.BufSiz/2;i++) 
   if (((i%128)==17)||((i%128)==18)||((i%128)==19))
      g_print("AcqBuf[i=%d]=%d, reminder=%d\n",i,AcqBuf[i],i%64);
*/
return BufSize;
}
//----------------------------------------------------------------------------------------------------------------------
void *AcquireData(gpointer Data)                                    //Data acquisition thread triggered by StartCallBack
{
gint i,j,Size,SpecSaved,NewBufs;
gchar Buf[512],Header[5],FNam[2048],Str[256],NSC_txt[256],FileMode[10];
gchar IniName[MAX_FNAME_LENGTH],ClrName[MAX_FNAME_LENGTH],B2hFile[MAX_FNAME_LENGTH],NameF[MAX_DIR_STRLEN+20];
glong PollTime,CollectedEvents;
FILE *Tp,*ListFp,*MacroFp;
gshort NScaler1,NScaler2,ScalerUpdateCounts,ConfirmBufSiz[2];
gshort IniCmd[256],ClrCmd[25],Cmd,Code;
gushort IniData[256],ClrData[256];
gshort EvtCmd[500],Mask[500],ScalerNaf[MAX_SCALER],ScalerD[MAX_SCALER];
struct timeval Tv;
gdouble ElapsedTime;
struct tm *TmStart;
gushort *AcqBuf;
guint32 *ScalerBuf;
char ParName[MAX_PAR][MAX_TEXT_FIELD];

CVBoardTypes  VMEBoard;
short         Link;
short         Device;
int32_t       BHandle;

for (i=0,NPar1=NPar2=0;i<Setup.Parameter.NPar;++i) { if (Setup.Parameter.N[i]>MAX_VME_STNS) ++NPar2; else ++NPar1; }

if (Setup.ListMode.ListOn)
   {
   switch (Setup.ListMode.Compr)
      {
      case 0: sprintf(FNam,"%s/%s.001",ListFDir,RunName); break;                               //IUAC Candle file format
      case 1: sprintf(FNam,"%s/%s.zls",ListFDir,RunName); break;         //Normal: The usual zls zero suppression scheme
      case 2: sprintf(FNam,"%s/%s.root",ListFDir,RunName); break;                                                 //ROOT
      case 3: sprintf(FNam,"%s/%s.csv",ListFDir,RunName);                                                          //csv
      }
   if (AcqSignal==Pause) strcpy(FileMode,"a"); else strcpy(FileMode,"w");            //If run was paused use append mode
   if (Setup.ListMode.Compr==0 || Setup.ListMode.Compr==1 || Setup.ListMode.Compr==3)
      {   
      if ((ListFp=fopen(FNam,FileMode))==NULL)
         {
         SAttention("Couldnt open List File\nFile permissions problem or disk full?");
         ProgramState=Free; pthread_exit(NULL);
         }
      }
   else
      {
      for (i=0;i<Setup.Parameter.NPar;++i) strcpy(ParName[i],Setup.Parameter.Name[i]);
      OpenRootFile(FNam,Setup.Parameter.NPar,ParName,"");
      }
   if (AcqSignal!=Pause) BytesWritten=0;
   if (Setup.ListMode.Compr==0)                                                                //IUAC Candle file header
      {
      if (AcqSignal==Pause)
         { sprintf(NSC_txt,"RESUME: %s resumed. Run #%04d\n",RunName,111); queue_text(resume,NSC_txt,ListFp); }
      else
         {
         sprintf(NSC_txt,"%s\n %s\n %s\n","LAMPS","A.Chatterjee","Candle Compatible File");
         queue_text(user,NSC_txt,ListFp); writeNames(Setup.Parameter.NPar,0,0,ListFp);
         sprintf(NSC_txt,"START : %s started. Run #%04d\n",RunName,111); queue_text(start,NSC_txt,ListFp);
         }
      }
   }

if (Setup.Macro.N)
   {
   sprintf(FNam,"%s/%s.mac",MacroDir,RunName);
   if ((MacroFp=fopen(FNam,"w"))==NULL)
      {
      SAttention("Couldnt open file for macro dump\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   }

if (AcqSignal!=Pause)
   { gettimeofday(&Tv,NULL); StartTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06; TStart=time(NULL); }
TmStart=localtime(&TStart);
gdk_threads_enter();
gtk_label_set_text(GTK_LABEL(S_Stat[0]),"Status: Acquiring");
gtk_label_set_text(GTK_LABEL(S_Stat[3]),RunName);
sprintf(Str,"Start: %02d:%02d:%02d",TmStart->tm_hour,TmStart->tm_min,TmStart->tm_sec);
gtk_label_set_text(GTK_LABEL(S_Stat[4]),Str);
sprintf(Str,"Prev. %s",SStop); gtk_label_set_text(GTK_LABEL(S_Stat[6]),Str);
gdk_threads_leave();

if (Setup.Macro.N)
   {
   fprintf(MacroFp,"#Macro file %s.mac opened at %02d:%02d:%02d\n",RunName,TmStart->tm_hour,TmStart->tm_min,
                    TmStart->tm_sec);
   fprintf(MacroFp,"#The following macros are shown as a function of buffer number in the table below\n");
   for (i=0,j=0;i<Setup.Macro.N;++i)
       {
       MacroCurr[i]=MacroPrev[i]=MacroDiff[i]=0.0;
       if (Setup.Macro.Display[i]) { fprintf(MacroFp,"# %s %s-diff",Setup.Macro.Name[i],Setup.Macro.Name[i]); ++j; }
       if (!((j+1)%4)) fprintf(MacroFp,"\n");
       }
    fprintf(MacroFp,"\n");
    }

gdk_threads_enter(); RefreshAll();
gtk_label_set_text(GTK_LABEL(S_Stat[5]),""); for (i=7;i<15;++i) gtk_label_set_text(GTK_LABEL(S_Stat[i]),"");
gdk_threads_leave();

sprintf(NameF,"%s/lamps.log",LogDir);
if ((LogFp=fopen(NameF,"r"))==NULL)
   {                                                                                   //No log file...so make a new one
   if ((LogFp=fopen(NameF,"w"))==NULL)                                //Create log file and write default headings in it
      {
      SAttention("Couldnt create file lamps.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   fprintf(LogFp,"Ion, q+             \nE, TV               \nNMR, I              \nCI (scale)          \n");
   fprintf(LogFp,"Target              \nTgt. Rot.           \nInfo 1              \nInfo 2              \n");
   fprintf(LogFp,"Info 3              \nInfo 4              \nInfo 5              \nInfo 6              \n");
   fprintf(LogFp,"-------------------------------------------------------\n");
   fclose(LogFp);
   }
else fclose(LogFp);

if (AcqSignal!=Pause)
   {
   sprintf(NameF,"%s/lamps.log",LogDir);
   if ((LogFp=fopen(NameF,"a"))==NULL)                                //Open log file and make the initial entries in it
      {
      SAttention("Couldnt open log file lamps.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   sprintf(Str,"%s",RunName); Pad(Str,30); fprintf(LogFp,"%-23s %s}\n","Run Name:",Str);
   AbbreviateFileName(Str,Setup.FName,MAX_FNAME_LENGTH); if (Setup.Modified) strcat(Str,"(?)");
   if (!strlen(Setup.FName)) sprintf(Str,"%s","none");
   Pad(Str,30); fprintf(LogFp,"%-23s %s}\n","Setup File:",Str);
   strcpy(Str,ctime(&TStart)); Str[24]='\0'; Pad(Str,30);    fprintf(LogFp,"%-23s %s}\n","Start:",Str);
   if (Setup.Oned.WSz==1) sprintf(Str,"%d 16-bit",Setup.Oned.N); else sprintf(Str,"%d 32-bit",Setup.Oned.N);
   Pad(Str,30); fprintf(LogFp,"%-23s %s}\n","1d_Spec:",Str);
   if (Setup.Twod.WSz==1) sprintf(Str,"%d 16-bit",Setup.Twod.N); else sprintf(Str,"%d 32-bit",Setup.Twod.N);
   Pad(Str,30); fprintf(LogFp,"%-23s %s}\n","2d_Spec:",Str);
   fprintf(LogFp,"%-23s %30s}\n","User  1:"," "); fprintf(LogFp,"%-23s %30s}\n","User  2:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User  3:"," "); fprintf(LogFp,"%-23s %30s}\n","User  4:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User  5:"," "); fprintf(LogFp,"%-23s %30s}\n","User  6:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User  7:"," "); fprintf(LogFp,"%-23s %30s}\n","User  8:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User  9:"," "); fprintf(LogFp,"%-23s %30s}\n","User 10:"," ");
   fprintf(LogFp,"%-23s %30s}\n","User 11:"," "); fprintf(LogFp,"%-23s %30s}\n","User 12:"," ");
   fprintf(LogFp,"%-23s %40s]\n","Remarks 1:"," "); fprintf(LogFp,"%-23s %40s]\n","Remarks 2:"," ");
   fprintf(LogFp,"%-23s %40s]\n","Remarks 3:"," "); fprintf(LogFp,"%-23s %40s]\n","Remarks 4:"," ");
   fclose(LogFp);
   }

if (AcqSignal==Pause) PeriodicLog(4,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
else
   {
   BuffersProcessed=0; BuffersAcquired=0; BufPrev=0; NewBufs=0; BytesPrev=0;
   PeriodicLog(0,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
                                                                                          //periodic.log initial entries
   sprintf(NameF,"%s/scaler.log",LogDir);
   if ((ScalerFp=fopen(NameF,"a"))==NULL)                                //Open scaler log file and make initial entries
      {
      SAttention("Couldnt open log file scaler.log\nFile permissions problem or disk full?");
      ProgramState=Free; pthread_exit(NULL);
      }
   fprintf(ScalerFp,"%s Start:%s\n",RunName,ctime(&TStart));
   fclose(ScalerFp);
   }

if (Setup.Hardware.AutoStopOn) pthread_create(&AStop,NULL,ControlAutoStop,NULL);                   //Thread for Autostop

if (AcqSignal==Stop) StartAcq(); else if (AcqSignal==Pause) ResumeAcq();
ElapsedTime=0.0; SpecSaved=0;
if (AcqSignal!=Pause) BytesAcquired=0;
AcqSignal=Resume;                                                          //We set this when acquisition is in progress
ScalerBuf=ScalerBuf1;
for (i=0;i<Setup.Scaler.NSc;++i) { ScalerBuf[i]=0; ScalerPrev[i]=0; ScalerCurr[i]=0; }
UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf);

//Simulation block starts here. Used for testing when there is no hardware.
if (Simulate)
   {
   while (TRUE)
       {
       if (BuffersAcquired%2) {AcqBuf=AcqBuf1; ScalerBuf=ScalerBuf1;} else {AcqBuf=AcqBuf2; ScalerBuf=ScalerBuf2;} 
       BytesRecv=SimulateRead(AcqBuf,ScalerBuf); //g_print("BytesReceived=%d\n",BytesRecv);  
       BytesAcquired+=BytesRecv;
       ++BuffersAcquired; ++NewBufs;
       if (BuffersAcquired>1) pthread_cancel(Spec);         //Request cancellation of the Spec thread (if it is running)
       if (Setup.ListMode.ListOn)
          {
          if (Setup.ListMode.Compr==2) WriteRootBlock(AcqBuf,(int)(BytesRecv/2/NPar1),Setup.Parameter.NPar);      //ROOT
          else                         { if (!CompressToDisk(ListFp,AcqBuf)) break; }                //zls, csv, Freedom
          }
       if (BuffersAcquired>1) pthread_join(Spec,NULL);        //Make sure Spec is really killed before starting it again
       pthread_create(&Spec,NULL,BuildSpectra,(void *)AcqBuf);
       if (RefreshRate && (NewBufs>=RefreshRate))
          { UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf); NewBufs=0; Safety(RunName,&ElapsedTime,&SpecSaved); }
       else if (BuffersAcquired==1) UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf);
       if ((Setup.PLogSetup.On) && !(BuffersAcquired % Setup.PLogSetup.BufCount)) 
          PeriodicLog(1,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
       if (Setup.Macro.N && !(BuffersAcquired % Setup.Macro.RefreshRate)) ComputeMacros(BuffersAcquired,MacroFp);
       if (AcqSignal==Stop) break;
       }
   if (AcqSignal==Stop) UpdateDisplay(&ElapsedTime,TRUE,ScalerBuf);
   else  UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf);
   if (Setup.ListMode.ListOn) 
      {
      if (Setup.ListMode.Compr==0)                                                                  //Candle file format
         {
         CollectedEvents=BytesAcquired/2/Setup.Parameter.NPar;
         if (AcqSignal==Stop)                                                              //Stop for Candle format file
            {
            sprintf(NSC_txt,"STOP: %s ends. Collected %ld events",RunName,CollectedEvents); 
            queue_text(stop,NSC_txt,ListFp); writeEndOfFile(ListFp);
            }
         else                                                                             //Pause for Candle format file
            { 
            sprintf(NSC_txt,"PAUSED: %s paused. So far %ld events",RunName,CollectedEvents); 
            queue_text(pauseNSC,NSC_txt,ListFp); 
            }
         }
      if (Setup.ListMode.Compr==2) CloseRootFile(); else fclose(ListFp);
      }
   if (AcqSignal==Pause)
      for (i=0;i<Setup.Scaler.NSc;++i) ScalerPending[i]=ScalerCurr[i];           //Useful only if acquisition was paused
   if (AcqSignal==Stop)
      {
      PeriodicLog(2,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
                                                                                            //periodic.log final entries
      if (Setup.Macro.N) 
         { ComputeMacros(BuffersAcquired,MacroFp); if (Setup.Macro.N) fclose(MacroFp); }         //Finish macro log file
      for (i=0;i<Setup.Oned.N;i++) 
          { sprintf(FNam,"%s/Spec_%s/%s%03d.z1d",SpecDir,RunName,RunName,i+1); Write1d(FNam,i,1); }
      if (Setup.Twod.WSz==1) 
         for (i=0;i<Setup.Twod.N;++i) 
             { sprintf(FNam,"%s/Spec_%s/%s%03d.z2d",SpecDir,RunName,RunName,i+1); Write2d16(FNam,i,1); }
      else 
         for (i=0;i<Setup.Twod.N;++i) 
             { sprintf(FNam,"%s/Spec_%s/%s%03d.z2d",SpecDir,RunName,RunName,i+1); Write2d32(FNam,i,1); }
      }
   else PeriodicLog(3,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
   ProgramState=Free; pthread_exit(NULL);
   return NULL;
   }
//Simulation block ends here

VMEBoard=cvV2718; Link=0; Device=0;
if (CAENVME_Init(VMEBoard,Link,Device,&BHandle) == cvSuccess)
    {
    printf("\n V2718 Opened... Crate is OK\n");
    }
else 
    {
    VMEBoard = cvV1718;
    for (Device=0;Device<10;Device++)
        {
        if (CAENVME_Init(VMEBoard,Link,Device,&BHandle) == cvSuccess)
           {
           printf("\n V1718 Opened... Crate is OK\n");
           break;
           }
        else 
           {
           printf("\n Error opening V2718/V1718 Controller!!! Check whether the Crate is down or the driver is loaded?\n");
           if (Device==9) exit(1);  
           }
        }
    }
//VMEInit(BHandle);
VMEInitCBLT(BHandle);
//VMEInitInterruptCBLT(BHandle);
//g_print("Just before Main Acquisition Loop\n");

//Start Main Acquisition Loop
while (TRUE)
    {
    if (BuffersAcquired%2) {AcqBuf=AcqBuf1; ScalerBuf=ScalerBuf1;} else {AcqBuf=AcqBuf2; ScalerBuf=ScalerBuf2;}
    //BytesRecv=VMEReadCycle(BHandle,AcqBuf,ScalerBuf);    //g_print("BytesReceived=%d\n",BytesRecv);
    //g_print("Just before VMEREadclbt\n");
    BytesRecv=VMEReadCBLT(BHandle,AcqBuf,ScalerBuf);    //g_print("BytesReceived=%d\n",BytesRecv);
    //BytesRecv=VMEInterruptReadCBLT(BHandle,AcqBuf,ScalerBuf);    //g_print("BytesReceived=%d\n",BytesRecv);
    //for (i=0;i<Setup.Scaler.NSc;i++) g_print("ScalerBuf[i=%d]=%u \n",i,ScalerBuf[i]);
    //g_print("AcqBuf[1]=%d,AcqBuf[33]=%d,AcqBuf[35]=%d\n",AcqBuf[1],AcqBuf[33],AcqBuf[35]);
    BytesAcquired+=BytesRecv;
    ++BuffersAcquired; ++NewBufs;
    if (BuffersAcquired>1) pthread_cancel(Spec);            //Request cancellation of the Spec thread (if it is running)
    if (Setup.ListMode.ListOn)
       {
       if (Setup.ListMode.Compr==2) WriteRootBlock(AcqBuf,(int)(BytesRecv/2/NPar1),Setup.Parameter.NPar);         //ROOT
       else                         { if (!CompressToDisk(ListFp,AcqBuf)) break; }
       }
    if (BuffersAcquired>1) pthread_join(Spec,NULL);           //Make sure Spec is really killed before starting it again
    pthread_create(&Spec,NULL,BuildSpectra,(void *)AcqBuf);
    if (RefreshRate && (NewBufs>=RefreshRate))
       { UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf); NewBufs=0; Safety(RunName,&ElapsedTime,&SpecSaved); }
    else if (BuffersAcquired==1) UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf);
    if ((Setup.PLogSetup.On) && !(BuffersAcquired % Setup.PLogSetup.BufCount))
       PeriodicLog(1,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
    if (Setup.Macro.N && !(BuffersAcquired % Setup.Macro.RefreshRate)) ComputeMacros(BuffersAcquired,MacroFp);
    if (AcqSignal==Stop) break;
    }
if (AcqSignal==Stop) UpdateDisplay(&ElapsedTime,TRUE,ScalerBuf);
else  UpdateDisplay(&ElapsedTime,FALSE,ScalerBuf);
if (Setup.ListMode.ListOn)
   {
   if (Setup.ListMode.Compr==0)                                                                     //Candle file format
      {
      CollectedEvents=BytesAcquired/2/Setup.Parameter.NPar;
      if (AcqSignal==Stop)                                                                 //Stop for Candle format file
         {
         sprintf(NSC_txt,"STOP: %s ends. Collected %ld events",RunName,CollectedEvents);
         queue_text(stop,NSC_txt,ListFp); writeEndOfFile(ListFp);
         }
      else                                                                                //Pause for Candle format file
         {
         sprintf(NSC_txt,"PAUSED: %s paused. So far %ld events",RunName,CollectedEvents);
         queue_text(pauseNSC,NSC_txt,ListFp);
         }
      }
   else if (Setup.ListMode.Compr==2) CloseRootFile(); 
   else fclose(ListFp); 
   }
if (AcqSignal==Pause)
   for (i=0;i<Setup.Scaler.NSc;++i) ScalerPending[i]=ScalerCurr[i];              //Useful only if acquisition was paused
if (AcqSignal==Stop)
   {
   PeriodicLog(2,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
                                                                                            //periodic.log final entries
   if (Setup.Macro.N)
      { ComputeMacros(BuffersAcquired,MacroFp); if (Setup.Macro.N) fclose(MacroFp); }            //Finish macro log file
   for (i=0;i<Setup.Oned.N;i++)
       { sprintf(FNam,"%s/Spec_%s/%s%03d.z1d",SpecDir,RunName,RunName,i+1); Write1d(FNam,i,1); }
   if (Setup.Twod.WSz==1)
      for (i=0;i<Setup.Twod.N;++i)
          { sprintf(FNam,"%s/Spec_%s/%s%03d.z2d",SpecDir,RunName,RunName,i+1); Write2d16(FNam,i,1); }
   else
      for (i=0;i<Setup.Twod.N;++i)
          { sprintf(FNam,"%s/Spec_%s/%s%03d.z2d",SpecDir,RunName,RunName,i+1); Write2d32(FNam,i,1); }
   }
else PeriodicLog(3,RunName,BuffersAcquired,BuffersProcessed,BytesWritten,TStart,StartTime,ScalerBuf1);
CAENVME_End(BHandle);
ProgramState=Free; pthread_exit(NULL);
return NULL;
}
//----------------------------------------------------------------------------------------------------------------------
void OverwriteStart(GtkWidget *W,GtkWidget *Win)
{
gtk_widget_destroy(Win);
ProgramState=AcqOn;
if (!Setup.Spectra.NoZero) { ZeroOned(-1); ZeroTwod(-1); }
fstart_(RunName,strlen(RunName));                                                     //Call user initialisation routine
PauseDuration=0L;
strcpy(PrevRun,RunName); pthread_create(&Acq,NULL,AcquireData,NULL);
}
//----------------------------------------------------------------------------------------------------------------------
void StartCallBack(GtkWidget *W,GtkWidget *StartWin)
{
gint Overwrite,i;
gchar ListFName[2048],Str[2070],DName[2048];
GtkWidget *Win,*Label,*But;

gtk_widget_destroy(GTK_WIDGET(StartWin)); Overwrite=0;

sprintf(DName,"%s/Spec_%s",SpecDir,RunName);
for (i=0;i<Setup.Oned.N;i++) sprintf(Setup.Files.Oned[i],"%s/%s%03d.z1d",DName,RunName,i+1);
for (i=0;i<Setup.Twod.N;i++) sprintf(Setup.Files.Twod[i],"%s/%s%03d.z2d",DName,RunName,i+1);
if (Setup.ListMode.ListOn)
   {
   switch (Setup.ListMode.Compr)
      {
      case 0: sprintf(ListFName,"%s/%s.001",ListFDir,RunName); break;                  //IUAC Candle/Freedom file format
      case 1: sprintf(ListFName,"%s/%s.zls",ListFDir,RunName); break;    //Normal: The usual zls zero suppression scheme
      case 2: sprintf(ListFName,"%s/%s.root",ListFDir,RunName); break;                                            //ROOT
      case 3: sprintf(ListFName,"%s/%s.csv",ListFDir,RunName);                                               //Excel csv
      }
   if (!access(ListFName,F_OK)) Overwrite=1;
   }
else
   if (!access(DName,F_OK)) Overwrite=2;                                                      //Check existence of DName
mkdir(DName,0755);                                        //Create directory (if it already exists, nothing will happen)
if (Overwrite)
   {
   Win=gtk_dialog_new();
   g_signal_connect_swapped(GTK_OBJECT(Win),"destroy",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(Win));
   gtk_window_set_title(GTK_WINDOW(Win),"Overwrite?"); gtk_container_border_width(GTK_CONTAINER(Win),5);
   gtk_widget_set_uposition(GTK_WIDGET(Win),400,300);
   if (Overwrite==1) sprintf(Str,"Overwrite %s?",ListFName);
   else              sprintf(Str,"Prev. data exists. Overwrite Spec. Files?");
   Label=gtk_label_new(Str); gtk_misc_set_padding(GTK_MISC(Label),10,10);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Win)->vbox),Label,TRUE,TRUE,0);
   But=gtk_button_new_from_stock(GTK_STOCK_YES);
   g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(OverwriteStart),Win);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Win)->action_area),But,TRUE,TRUE,0);
   But=gtk_button_new_from_stock(GTK_STOCK_CANCEL);
   g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(Win));
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Win)->action_area),But,TRUE,TRUE,0);
   gtk_widget_show_all(Win);
   return;
   }
ProgramState=AcqOn;
if (!Setup.Spectra.NoZero) { ZeroOned(-1); ZeroTwod(-1); }
fstart_(RunName,strlen(RunName));                                                     //Call user initialisation routine
PauseDuration=0L;
strcpy(PrevRun,RunName); pthread_create(&Acq,NULL,AcquireData,NULL);
}
//----------------------------------------------------------------------------------------------------------------------
void CancelCallBack(GtkWidget *W,GtkWidget *StartWin)
{ gtk_widget_destroy(GTK_WIDGET(StartWin)); }
//----------------------------------------------------------------------------------------------------------------------
void StartWinDestroyed(GtkWidget *W,gpointer Unused)
{ ProgramState=Free; }
//----------------------------------------------------------------------------------------------------------------------
void RunNameCallBack(GtkWidget *W,gpointer Unused)
{ strcpy(RunName,gtk_entry_get_text(GTK_ENTRY(W))); }
//----------------------------------------------------------------------------------------------------------------------
void IncrementRunName()
{
gint i,RunNo,L,S;
gchar Str[120];

strcpy(RunName,PrevRun);
if (!strcmp(PrevRun,"Dummy")) return;
L=strlen(PrevRun);
for (i=L-1;i>0;i--) if (!isdigit(PrevRun[i])) break;
if ( (i==L-1) && (L<36) ) { RunName[L]='1'; RunName[L+1]='\0'; return; }
RunNo=atoi(&PrevRun[i+1])+1; sprintf(Str,"%d",RunNo); S=strlen(Str);
RunName[L-S]='\0'; strcat(RunName,Str);
}
//----------------------------------------------------------------------------------------------------------------------
void AutoStopCallBack(GtkWidget *W,gpointer Unused)
{ Setup.Hardware.AutoStop=atoi(gtk_entry_get_text(GTK_ENTRY(W))); }
//----------------------------------------------------------------------------------------------------------------------
void AutoStopToggle(GtkWidget *CheckBut,GtkWidget *Entry)
{
if (GTK_TOGGLE_BUTTON(CheckBut)->active) { Setup.Hardware.AutoStopOn=TRUE;  gtk_widget_set_sensitive(Entry,TRUE); }
                                    else { Setup.Hardware.AutoStopOn=FALSE; gtk_widget_set_sensitive(Entry,FALSE); }
}
//----------------------------------------------------------------------------------------------------------------------
void StartAcquisition(void)
{
gint i;
gchar Str[MAX_FNAME_LENGTH+20];
GtkWidget *Win,*VBox,*HBox,*Label,*But,*Entry,*CheckBut;
static GdkColor White = {0,0xFFFF,0xFFFF,0xFFFF};
static GdkColor Black = {0,0x0000,0x0000,0x0000};
static GdkColor Gold  = {0,0xBBBB,0x9999,0x0000};
static GdkColor Blue  = {0,0x0000,0x0000,0xFFFF};
GtkStyle *RunStyle,*BlueStyle;

CreateDir();                                     //Create directories as per user preferences if they dont exist already
RunStyle=gtk_style_copy(gtk_widget_get_default_style());                              //Copy default style to this style
RunStyle->text[0]=White  /*Normal Text*/; RunStyle->text[3]=White /*Selected text*/;
RunStyle->fg[5]  =Black /*Box boundary*/; RunStyle->text[5]=Gold       /*Box fill*/;
BlueStyle=gtk_style_copy(gtk_widget_get_default_style());                             //Copy default style to this style
for (i=0;i<5;i++) { BlueStyle->fg[i]=BlueStyle->text[i]=Blue; BlueStyle->bg[i]=White; }     //Set colours for all states

ProgramState=AcqOn; IncrementRunName();
Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
g_signal_connect(GTK_OBJECT(Win),"destroy",G_CALLBACK(StartWinDestroyed),NULL);
gtk_window_set_title(GTK_WINDOW(Win),"Start Acquisition"); gtk_widget_set_uposition(GTK_WIDGET(Win),300,300);
gtk_container_set_border_width(GTK_CONTAINER(Win),10);
VBox=gtk_vbox_new(FALSE,0); gtk_container_add(GTK_CONTAINER(Win),VBox);                     //VBox for the entire window

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
Label=gtk_label_new("Prev. Run:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);
sprintf(Str,"%s",PrevRun); Label=gtk_label_new(Str); SetStyleRecursively(Label,BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
Label=gtk_label_new("Run Name:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);
Entry=gtk_entry_new_with_max_length(35); gtk_box_pack_start(GTK_BOX(HBox),Entry,FALSE,FALSE,0);
SetStyleRecursively(Entry,RunStyle);
gtk_entry_set_text(GTK_ENTRY(Entry),RunName);
gtk_widget_set_usize(GTK_WIDGET(Entry),130,25);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(RunNameCallBack),NULL);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
Label=gtk_label_new("Setup File:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);
AbbreviateFileName(Str,Setup.FName,MAX_FNAME_LENGTH);
if (Setup.Modified) strcat(Str,"(?)");
if (!strlen(Setup.FName)) sprintf(Str,"%s","none");
Label=gtk_label_new(Str); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
CheckBut=gtk_check_button_new_with_label("Auto Stop");
gtk_box_pack_start(GTK_BOX(HBox),CheckBut,FALSE,FALSE,0);
GTK_TOGGLE_BUTTON(CheckBut)->active=Setup.Hardware.AutoStopOn;
Entry=gtk_entry_new_with_max_length(10); gtk_box_pack_start(GTK_BOX(HBox),Entry,FALSE,FALSE,0);
sprintf(Str,"%d",Setup.Hardware.AutoStop); gtk_entry_set_text(GTK_ENTRY(Entry),Str);
gtk_widget_set_usize(GTK_WIDGET(Entry),50,25);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(AutoStopCallBack),NULL);
Label=gtk_label_new("sec"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,5);
if (Setup.Hardware.AutoStopOn) gtk_widget_set_sensitive(Entry,TRUE); else gtk_widget_set_sensitive(Entry,FALSE);
g_signal_connect(GTK_OBJECT(CheckBut),"toggled",G_CALLBACK(AutoStopToggle),Entry);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
But=gtk_button_new_from_stock(GTK_STOCK_YES);
gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,5);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(StartCallBack),GTK_OBJECT(Win));
But=gtk_button_new_from_stock(GTK_STOCK_CANCEL);
gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,5);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(CancelCallBack),GTK_OBJECT(Win));

gtk_widget_show_all(Win);
gtk_style_unref(RunStyle); gtk_style_unref(BlueStyle);
}
//----------------------------------------------------------------------------------------------------------------------
void StartNoZero(GtkWidget *W,gpointer Data)
{
if ( (ProgramState==AnalysisOn) || (ProgramState==ReWriteOn) )
   { Attention(0,"Sorry...Another task is in progress"); return; }
if (BatchRunning) { Attention(0,"Not permitted... Batch acquisition in progress"); return; }
if (AcqSignal == Resume) { Attention(0,"Acquisition already in progress"); return; }
if (AcqSignal == Pause)  { Attention(0,"Acquisition is Paused. Click Resume."); return; }
Setup.Spectra.NoZero=TRUE;
StartAcquisition();
}
//----------------------------------------------------------------------------------------------------------------------
void StartNormal(GtkWidget *W,gpointer Data)
{
if ( (ProgramState==AnalysisOn) || (ProgramState==ReWriteOn) )
   { Attention(0,"Sorry...Another task is in progress"); return; }
if (BatchRunning) { Attention(0,"Not permitted... Batch acquisition in progress"); return; }
if (BatchRunning) { Attention(0,"Not permitted during batch acquisition"); return; }
if (AcqSignal == Resume) { Attention(0,"Acquisition already in progress"); return; }
if (AcqSignal == Pause)  { Attention(0,"Acquisition is Paused. Click Resume."); return; }
Setup.Spectra.NoZero=FALSE;
StartAcquisition();
}
//----------------------------------------------------------------------------------------------------------------------
void PauseAcquisition(GtkWidget *W,gpointer Data)
{
/* Not working at present
gshort Code;
struct timeval Tv;

if (BatchRunning) { Attention(0,"Not permitted during batch acquisition"); return; }
if (AcqSignal != Resume) { Attention(0,"Acquisition is not running"); return; }
AcqSignal=Pause;
gtk_label_set_text(GTK_LABEL(S_Stat[0]),"Paused");
gettimeofday(&Tv,NULL); PauseTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
*/
}
//----------------------------------------------------------------------------------------------------------------------
void ResumeAcquisition(GtkWidget *W,gpointer Data)
{
/* Not working at present
struct timeval Tv;
gdouble TimeNow;

if ( (AcqSignal != Pause) || (ProgramState==AnalysisOn) || (ProgramState==ReWriteOn) || BatchRunning)
   { Attention(0,"Sorry...Resume not allowed at this point"); return; }
gtk_label_set_text(GTK_LABEL(S_Stat[0]),"Acq. On");
ProgramState=AcqOn; Setup.Spectra.NoZero=TRUE;

ProgramState=AcqOn;
gettimeofday(&Tv,NULL); TimeNow=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;
PauseDuration+=TimeNow-PauseTime;
strcpy(PrevRun,RunName); pthread_create(&Acq,NULL,AcquireData,NULL);
*/
}
//----------------------------------------------------------------------------------------------------------------------
void StopNicely(void)
{
gshort Code;

AcqSignal=Stop;
fstop_();                                                   //Execute user written code everytime acquisition is stopped
}
//----------------------------------------------------------------------------------------------------------------------
void StopAcquisition(GtkWidget *W,gpointer Data)
{
gshort Code;

if (BatchRunning) { Attention(0,"Not permitted... Batch acquisition running"); return; }
if (AcqSignal == Stop) { Attention(0,"Acquisition is not running"); return; }
if (AcqSignal == Pause) { Attention(0,"Please resume acquisition first"); return; }
AcqSignal=Stop;
SendStopAcq();
fstop_();                                                   //Execute user written code everytime acquisition is stopped
}
//----------------------------------------------------------------------------------------------------------------------
void RemoveInitialBlanks(gchar *Str)
{
gint i;
gchar Str2[100];

for (i=0;i<strlen(Str);i++) if (Str[i] != ' ') break;
strcpy(Str2,&Str[i]); strcpy(Str,Str2);
}
//----------------------------------------------------------------------------------------------------------------------
gint GetNaf(gchar *Str)
{
gint N,A,F;
gchar TStr[100];

Str=index(Str,(gint)':'); strcpy(TStr,&Str[1]); RemoveInitialBlanks(TStr); N=atoi(TStr);
Str=index(TStr,(gint)' '); RemoveInitialBlanks(Str); A=atoi(Str);
Str=index(Str,(gint)' '); RemoveInitialBlanks(Str); F=atoi(Str);
return (N<<9)+(A<<5)+F;
}
//----------------------------------------------------------------------------------------------------------------------
gushort GetVal(gchar *Str)
{
Str=index(Str,(gint)'='); return (gushort)atoi(&Str[1]);
}
//----------------------------------------------------------------------------------------------------------------------

