#include <gtk/gtk.h>
#include <sys/vfs.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "lamps.h"
#include "common.h"                                                                           //IUAC Freedom header file

//Function templates
void Attention(gint XPos,gchar *Messg);
void GetMainMenu(GtkWidget *Win,GtkWidget **MenuBar); 
void InitializeFont(void); void InitializeColours(void); void DefaultSetup(void); void InitializeFitParas(void); 
void InitializeCalibParas(void); void InitializeBGate(void); void InitializeFlags(void); void InitializeSpecFileNames();
void InitializeSearchedPeaks(void); void InitializeFileColours(void);
void NoCalib(GtkWidget *W,gpointer Unused); void InitializePrefs(void);
void SetStyleRecursively(GtkWidget *W,gpointer Data);
void Screen1(GtkWidget *W,gpointer Data); void Screen2(GtkWidget *W,gpointer Data);
void Screen3(GtkWidget *W,gpointer Data); void Screen4(GtkWidget *W,gpointer Data);
void PrevScreen(GtkWidget *W,gpointer Data); void LastScreen(GtkWidget *W,gpointer Data);
void ScreenN(GtkWidget *W,gpointer Data); void NextScreen(GtkWidget *W,gpointer Data);

//Global variables
datapack buf,readbuf;                                                                                  //NSC data buffer
struct Setup Setup;                                                                                //The setup variables
struct VMESpecial VMESpecial;                                       //For VME module special functions like DC mode, etc
struct PsBGated PsBGated[MAX_PSEUDO];                                                         //Banana gated pseudo type
enum ProgramState ProgramState;                                               //The current running state of the program
enum ReWriteRequest ReWriteRequest;                       //Control of list rewrite (see rewrite.c, zlsgls.c, freedom.c)
gboolean BatchRunning;                                                                     //Status of batch acquisition
gboolean CommonZoom,RealScroll,RealScroll2;                            //For common zoom and scroll of 1d and 2d spectra
guint16 *Oned16,*Twod16;                                                                   //Pointers for 16-bit spectra
guint32 *Oned32,*Twod32,*Proj;                                                             //Pointers for 32-bit spectra
gint Off1d[MAX_1D],Off2d[MAX_2D],OffProj[MAX_2D];                                         //Offsets into spectrum memory
gint Screen=0;                                                                       //Screen number for spectra display
gint FrozenWin=-1;                                                    //Window number that is frozen by user interaction
gboolean UtilBusy=0;                         //Flag indicating that Utilities is in use. Prevents running multiple utilities
gint ScreenSpecNo[SCREEN_TOT][MAX_SCREENS],ScreenSpecType[SCREEN_TOT][MAX_SCREENS]; //Info: each spec win of each screen
GtkWidget *SpecWin[SCREEN_TOT],*Canvas[SCREEN_TOT];                                            //Global spectrum widgets
GtkObject *HScrlAdj[SCREEN_TOT],*VScrlAdj[SCREEN_TOT];                  //Global adjustmnets for horiz. and vert. Scroll
gfloat XSlope[SCREEN_TOT],CountsSlope[SCREEN_TOT];             //These slope arrays are used both by plot1.c and plot2.c
gint CanvasW[SCREEN_TOT],CanvasH[SCREEN_TOT];                                         //Used by both plot1.c and plot2.c
gint AreaMonitor,AreaWinOpen,OvWinOpen,FitWinOpen,CalibWinOpen,AssistWinOpen,BananaWinOpen,BananaDrawMode,BananaShowing,
     BananaWinNo,BananaLineType,BananaMulti,PkSearchOpen,ScalerWinOpen;
GdkFont *Font;
gint Theme1d,Theme2d;                                                                    //Theme settings. -1 for random
GdkGC *Gc;                                                                            //Graphics context for 1d 2d plots
GdkColor Colour1D[10];   //0=Backg,1=Plot,2=FitBkg,3=Axis,4=Title,5=Cursors,6=Pk Markers,7=Fit ROI,8=Fit,9=Perm. Cursors
GdkColor Colour2D[10];                                      //0=Background,1=Axis,2=Title,3=Box,4=Permanent Box,5=Banana
GdkColor ColourOv[MAX_OVERLAP];                                                                    //Colours for overlap
GdkColor ColourMB[7];                                                               // Colours for multiple banana gates
glong D2PenColours[32][3];                                                                    //RGB Colours for 2d plots
gint ThemeChanged;
struct WinProperties Prop[SCREEN_TOT];
struct FitType Fit;                                                                                 //The Fit parameters
struct Calibration Calibration[MAX_TOTAL_PAR];                                           //Calibration of each parameter
struct BGate BGate;                                                                            //Banana gate held in RAM
GtkWidget *S_Stat[15],*S_Scaler[4];                                                                 //Status bar widgets
enum AnalysisRequest AnalysisRequest;
gchar SelRun[MAX_TEXT_FIELD];                                             //Used for run name in iospec.c and readfile.c
gushort AcqBuf1[MAX_BUFSIZ],AcqBuf2[MAX_BUFSIZ];                                               //Two acquisition buffers
guint ScalerBuf1[MAX_SCALER],ScalerBuf2[MAX_SCALER];                                    //Buffers containing Scaler data 
gulong ScalerCurr[MAX_SCALER],ScalerPrev[MAX_SCALER];              //Scaler values from the current and previous buffers
gint ScalerOverflows[MAX_SCALER];                                              //The number of overflows for each scaler
gulong ScalerPending[MAX_SCALER];                                                            //Pending value after Pause
gint DrvFd;                                                                                     //Driver file descriptor
gchar RunName[40],PrevRun[40];                                                    //Name of current run and previous run
enum AcqSignal AcqSignal;                                                                       //Stop, Pause and Resume
gint RefreshRate,RefreshOptimum;                                    //The interval (no. of buffers) for screen refreshes
gchar SStop[40];                                                    //The stop time of time of this, or the previous run
GtkWidget **ScalerTotal,**ScalerRate,**ScalerDRate;                                  //Globals for scaler display window
struct BGate MultiBGate[7];                                              //We allow 7 extra banana gates to be displayed
gchar MultiBGateNames[7][LONG_TEXT_FIELD];                                       //File names for the extra banana gates
gboolean MultiBGateFlags[7];                                                         //Flags to indicate bgate is active
GtkWidget **MultiBGateButtons;                                        //Buttons holding file names of multi banana gates
gfloat MacroCurr[MAX_MACRO],MacroPrev[MAX_MACRO],MacroDiff[MAX_MACRO];                       //Computed values of macros
gboolean LogOutBox,MacroOutBox;                                                          //To prevent multiple instances
glong BytesWritten;
struct FileOpenType *FileX;                                                                    //The file browser widget
gchar SetupDir[MAX_DIR_STRLEN],ListFDir[MAX_DIR_STRLEN],BanDir[MAX_DIR_STRLEN],SpecDir[MAX_DIR_STRLEN],
      BatDir[MAX_DIR_STRLEN],CalDir[MAX_DIR_STRLEN],LogDir[MAX_DIR_STRLEN],MacroDir[MAX_DIR_STRLEN];         //Dir prefs
guint PktLen;                                                                                                    //Added
gchar Pkt[1000];                                                                                                 //Added
gboolean Simulate;                                          //Added for testing acquisition without without VME hardware
GtkWidget *PrevWin;                             //Defined global in main.c. Used by setup.c, macro.c, control.c, batch.c
gint MainX,MainY,MainH;                                                                        //Geometry of main window
gint MonXRes,MonYRes,TopSpace,BotSpace,XBorder,YBorder,CanvasMinW,CanvasMinH,TopOfset;
//----------------------------------------------------------------------------------------------------------------------
void SavePrefs(void)
{
FILE *Fp;

if ((Fp=fopen(".lamps_prefs","w")))
   {
   fprintf(Fp,"SetupDir= %s\n",SetupDir); fprintf(Fp,"ListFDir= %s\n",ListFDir);
   fprintf(Fp,"BanDir= %s\n",BanDir); fprintf(Fp,"SpecDir= %s\n",SpecDir);
   fprintf(Fp,"BatDir= %s\n",BatDir); fprintf(Fp,"CalDir= %s\n",CalDir);
   fprintf(Fp,"LogDir= %s\n",LogDir); fprintf(Fp,"MacroDir= %s\n",MacroDir);
   fprintf(Fp,"Theme1d= %d\n",Theme1d);
   fprintf(Fp,"Theme2d= %d\n",Theme2d);
   fprintf(Fp,"MonXRes= %d\n",MonXRes);
   fclose(Fp);
   }
}
//----------------------------------------------------------------------------------------------------------------------
void DestroyMain(GtkWidget *W,gpointer Data)
{
if (ProgramState == Free) { SavePrefs(); gtk_main_quit(); }
else                      Attention(0,"Cant quit now. Task in progress");
}
//----------------------------------------------------------------------------------------------------------------------
gboolean DeleteMain(GtkWidget *W,GdkEvent *Event,gpointer Data)
{
if (ProgramState != Free) { Attention(0,"Cant quit now. Task in progress"); return TRUE; };
return FALSE;
}
//----------------------------------------------------------------------------------------------------------------------
void RefreshRateCallBack(GtkWidget *W,gpointer Data)
{
const gchar *Str;

Str=gtk_entry_get_text(GTK_ENTRY(W));
if (!strcmp(Str,"Optimum")) { RefreshRate=100; RefreshOptimum=1; return; }
else if (!strcmp(Str,"No Refresh")) { RefreshRate=0; RefreshOptimum=0; return; }
else { RefreshRate=atoi(Str); RefreshOptimum=0; }
}
//----------------------------------------------------------------------------------------------------------------------
void CommonZoomCallBack(GtkWidget *CheckBut,gpointer Data)
{
RealScroll=TRUE; RealScroll2=TRUE;                                                                   //Extra precaution!
if (GTK_TOGGLE_BUTTON(CheckBut)->active) CommonZoom=TRUE;
else                                     CommonZoom=FALSE;
}
//----------------------------------------------------------------------------------------------------------------------
void WinReady(GtkWidget *W,gpointer Unused)
{
gint MainW;

gtk_window_get_position(GTK_WINDOW(W),&MainX,&MainY);
gtk_window_get_size(GTK_WINDOW(W),&MainW,&MainH);
DefaultSetup();
}
//----------------------------------------------------------------------------------------------------------------------
gint main(int argc,char *argv[])
{
GtkWidget *Win,*VBox,*VBox1,*MenuBox,*MenuBar,*HBox,*HBox1,*Combo,*Label,*But,*CheckBut;
GList *GList;
static GdkColor RedC    = {0,0xFFFF,0x0000,0x0000};
static GdkColor BlueC  =  {0,0x0000,0x0000,0xFFFF};
GtkStyle *RedStyle,*BlueStyle;
gint i;
struct statfs StatBuf;
gchar Str[80];
gfloat DFree;

#if GLIB_CHECK_VERSION(2,32,0)
//Avoid g_thread_init. It is deprecated.
#else
g_thread_init(NULL); //GLib older than 2.32
#endif

gdk_threads_init(); gdk_threads_enter();

gtk_init(&argc,&argv); ProgramState=Free;
InitializeFont(); InitializeColours(); InitializeFlags(); InitializePrefs();
InitializeFitParas(); InitializeFileColours(); InitializeCalibParas(); NoCalib(NULL,NULL);
InitializeBGate(); InitializeSpecFileNames(); InitializeSearchedPeaks();
strcpy(RunName,"Dummy"); strcpy(PrevRun,"Dummy");                                                            //Run names

Simulate=FALSE; if (argc==2) if (!strcmp(argv[1],"-s")) Simulate=TRUE;

RedStyle=gtk_style_copy(gtk_widget_get_default_style()); BlueStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { RedStyle->fg[i]=RedStyle->text[i]=RedC; BlueStyle->fg[i]=BlueStyle->text[i]=BlueC; }

statfs("./",&StatBuf);                                                                             //Get disk statistics

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
g_signal_connect(GTK_OBJECT(Win),"map-event",G_CALLBACK(WinReady),NULL);
g_signal_connect(GTK_OBJECT(Win),"delete_event",G_CALLBACK(DeleteMain),NULL);
g_signal_connect(GTK_OBJECT(Win),"destroy",G_CALLBACK(DestroyMain),NULL);
gtk_window_set_title(GTK_WINDOW(Win),"LAMPS_OFFLINE: A.Chatterjee, Abhinav Kumar, K.Ramachandran updated 21 Nov 2025");
gtk_window_set_policy(GTK_WINDOW(Win),FALSE,FALSE,TRUE);

VBox=gtk_vbox_new(FALSE,0); gtk_container_add(GTK_CONTAINER(Win),VBox);
MenuBox=gtk_vbox_new(FALSE,1);
gtk_box_pack_start(GTK_BOX(VBox),MenuBox,FALSE,FALSE,0);

GetMainMenu(Win,&MenuBar); 
gtk_box_pack_start(GTK_BOX(MenuBox),MenuBar,FALSE,TRUE,0);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
//--------------------------------------------------Screen Selector-----------------------------------------------------
VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,FALSE,0); 
Label=gtk_label_new("Screen Selector"); gtk_box_pack_start(GTK_BOX(VBox1),Label,FALSE,FALSE,0); 
SetStyleRecursively(Label,RedStyle); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
But=gtk_button_new_with_label("1"); gtk_box_pack_start(GTK_BOX(HBox1),But,FALSE,FALSE,0);
gtk_widget_set_size_request(GTK_WIDGET(But),60,-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(Screen1),NULL);
But=gtk_button_new_with_label("2"); gtk_box_pack_start(GTK_BOX(HBox1),But,FALSE,FALSE,0);
gtk_widget_set_size_request(GTK_WIDGET(But),60,-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(Screen2),NULL);
But=gtk_button_new_with_label("+"); gtk_box_pack_start(GTK_BOX(HBox1),But,FALSE,FALSE,0);
gtk_widget_set_size_request(GTK_WIDGET(But),60,-1); 
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(NextScreen),NULL);
But=gtk_button_new_with_label("N"); gtk_box_pack_start(GTK_BOX(HBox1),But,FALSE,FALSE,0);
gtk_widget_set_size_request(GTK_WIDGET(But),80,-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(ScreenN),NULL);
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
But=gtk_button_new_with_label("Custom"); gtk_box_pack_start(GTK_BOX(HBox1),But,FALSE,FALSE,0);
gtk_widget_set_size_request(GTK_WIDGET(But),120,-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(Screen3),NULL);
//But=gtk_button_new_with_label("4"); gtk_box_pack_start(GTK_BOX(HBox1),But,FALSE,FALSE,0);
//gtk_widget_set_size_request(GTK_WIDGET(But),40,-1);
//g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(Screen4),NULL);
But=gtk_button_new_with_label("-"); gtk_box_pack_start(GTK_BOX(HBox1),But,FALSE,FALSE,0);
gtk_widget_set_size_request(GTK_WIDGET(But),60,-1); 
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(PrevScreen),NULL);
But=gtk_button_new_with_label("Last"); gtk_box_pack_start(GTK_BOX(HBox1),But,FALSE,FALSE,0);
gtk_widget_set_size_request(GTK_WIDGET(But),80,-1); 
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(LastScreen),NULL);
//--------------------------------------------------Refresh Rate--------------------------------------------------------
VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,FALSE,0); 
Label=gtk_label_new("Refresh Rate"); gtk_box_pack_start(GTK_BOX(VBox1),Label,FALSE,FALSE,0); 
SetStyleRecursively(Label,BlueStyle);
Combo=gtk_combo_new(); gtk_widget_set_size_request(GTK_WIDGET(Combo),87,-1); RefreshRate=100; RefreshOptimum=1;
gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(Combo)->entry),TRUE);
GList=NULL;
GList=g_list_append(GList,"Optimum"); GList=g_list_append(GList,"1 Buffer"); GList=g_list_append(GList,"10 Buffers");
GList=g_list_append(GList,"100 Buffers"); GList=g_list_append(GList,"500 Buffers"); 
GList=g_list_append(GList,"No Refresh");
gtk_combo_set_popdown_strings(GTK_COMBO(Combo),GList);                                                //Define the popup
gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry),"Optimum");
g_signal_connect(GTK_OBJECT(GTK_COMBO(Combo)->entry),"changed",G_CALLBACK(RefreshRateCallBack),NULL);
gtk_box_pack_start(GTK_BOX(VBox1),Combo,FALSE,FALSE,1);
//--------------------------------------------------Common Zoom---------------------------------------------------------
CheckBut=gtk_check_button_new_with_label("Common Zoom"); gtk_box_pack_start(GTK_BOX(VBox1),CheckBut,FALSE,FALSE,1); 
g_signal_connect(GTK_OBJECT(CheckBut),"toggled",G_CALLBACK(CommonZoomCallBack),NULL);
//--------------------------------------------------Status and Disk-----------------------------------------------------
VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[0]=gtk_label_new("Status: Free "); SetStyleRecursively(S_Stat[0],RedStyle); 
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[0],FALSE,FALSE,0);
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
sprintf(Str,"Disk Cap: %3.1fGb",(gfloat)StatBuf.f_blocks*StatBuf.f_bsize/1024.0/1024.0/1024.0);
S_Stat[1]=gtk_label_new(Str); SetStyleRecursively(S_Stat[1],RedStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[1],FALSE,FALSE,0);
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
DFree=(gfloat)StatBuf.f_bavail*StatBuf.f_bsize/1024.0/1024.0/1024.0; sprintf(Str,"Disk Free: %-3.3fGb",DFree);
if (DFree<1.0) { DFree=1024.0*DFree; sprintf(Str,"Disk Free: %-3.1fMb",DFree); }
if (DFree<1.0) { DFree=1024.0*DFree; sprintf(Str,"Disk Free: %-3.1fKb",DFree); }
S_Stat[2]=gtk_label_new(Str); SetStyleRecursively(S_Stat[2],RedStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[2],FALSE,FALSE,0);
//------------------------------------------------Run Start/Stop--------------------------------------------------------
VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[3]=gtk_label_new("Run:"); SetStyleRecursively(S_Stat[3],BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[3],FALSE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[4]=gtk_label_new("Start:");   SetStyleRecursively(S_Stat[4],BlueStyle); 
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[4],FALSE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[5]=gtk_label_new("Elapsed:"); SetStyleRecursively(S_Stat[5],BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[5],FALSE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[6]=gtk_label_new("Stop:");    SetStyleRecursively(S_Stat[6],BlueStyle); 
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[6],FALSE,FALSE,0);
//-----------------------------------------------Buffers and Speed------------------------------------------------------
VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[ 7]=gtk_label_new("Buffs Acq:"); SetStyleRecursively(S_Stat[ 7],RedStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[7],FALSE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[ 8]=gtk_label_new("Processed:"); SetStyleRecursively(S_Stat[ 8],RedStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[8],FALSE,FALSE,0);
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[ 9]=gtk_label_new("Kb/s:"); SetStyleRecursively(S_Stat[ 9],RedStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[9],FALSE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[10]=gtk_label_new("Evt/s:"); SetStyleRecursively(S_Stat[10],RedStyle); 
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[10],FALSE,FALSE,0);
//-----------------------------------------------Bytes Acq, File Bytes--------------------------------------------------
VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[11]=gtk_label_new("BytesAcqd.:"); SetStyleRecursively(S_Stat[11],BlueStyle); 
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[11],FALSE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[12]=gtk_label_new("ListF Bytes:");  SetStyleRecursively(S_Stat[12],BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[12],FALSE,FALSE,0);
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[13]=gtk_label_new("EventsAcq:");  SetStyleRecursively(S_Stat[13],BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[13],FALSE,FALSE,0);
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Stat[14]=gtk_label_new("Dead  Time:");  SetStyleRecursively(S_Stat[14],BlueStyle);
gtk_box_pack_start(GTK_BOX(HBox1),S_Stat[14],FALSE,FALSE,0);
//-----------------------------------------------------Scalers----------------------------------------------------------
VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,FALSE,0); 
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Scaler[0]=gtk_label_new("Scaler1:"); gtk_box_pack_start(GTK_BOX(HBox1),S_Scaler[0],FALSE,FALSE,0);
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Scaler[1]=gtk_label_new("Scaler2:"); gtk_box_pack_start(GTK_BOX(HBox1),S_Scaler[1],FALSE,FALSE,0);
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Scaler[2]=gtk_label_new("Scaler3:"); gtk_box_pack_start(GTK_BOX(HBox1),S_Scaler[2],FALSE,FALSE,0);
HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox1),HBox1,FALSE,FALSE,0);
S_Scaler[3]=gtk_label_new("Scaler4:"); gtk_box_pack_start(GTK_BOX(HBox1),S_Scaler[3],FALSE,FALSE,0);

gtk_widget_show_all(Win);
gtk_style_unref(RedStyle); gtk_style_unref(BlueStyle);
gtk_window_move(GTK_WINDOW(Win),0,0);

gtk_main(); gdk_threads_leave();
g_list_free(GList);
return 0;
}
//----------------------------------------------------------------------------------------------------------------------
