#define GTK_ENABLE_BROKEN
#include <gtk/gtk.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include "lamps.h"
#include "common.h"

//Function Templates
void Attention(gint XPos,gchar *Messg);
void SetStyleRecursively(GtkWidget *W,gpointer Data);
void AbbreviateFileName(gchar *Dest,gchar *Src,gint MaxLen);
void bstart_(void); void fstart_(gchar *RunName,gint Len); void fstop_(void); void bstop_(void);
void SAttention(gchar *Messg);
int FreedomRead(FILE *ListFile,glong *ZBufs,glong *EvtsRead,glong *BytsRead,
                gboolean OptionReWrite,gushort *OutBuf,gint *NewEvts);
int FreedomSkip(FILE *ListFile);
gboolean writeEventBlock(gint eventSize,gint ev_per_block,gushort data[],FILE *Fp);
void writeNames(int noOfAdcs,int noOfSingles,int noOfScalers,FILE *Fp);
void queue_text(enum blocktype block,gchar *txt,FILE *Fp);
void writeEndOfFile(FILE *Fp);
gint ZlsGlsRead(FILE *ListFile,gushort *Buf,glong *ZBufs,glong *EvtsRead,glong *BytsRead,
                gboolean OptionReWrite,gushort *OutBuf,gint *NewEvts);
gint CSVRead(FILE *ListFile,gushort *Buf,glong *ZBufs,glong *EvtsRead,glong *BytsRead,
                gboolean OptionReWrite,gushort *OutBuf,gint *NewEvts);
gint ZlsGlsSkip(FILE *ListFile);
void Update(gdouble StartTime,gchar *FName,glong FSize,glong ZBufs,glong BytsRead,glong EvtsRead);
gint ZlsWrite(FILE *Fp,gushort *Buf,gint NEvt,gint NPar);
gint CSVWrite(FILE *Fp,gushort *Buf,gint NEvt,gint NPar);
void RadwareWrite(FILE *Fp,gushort *OutBuf,gint NEvt,gint NPar);
void RadwareWriteHeader(FILE *Fp);
void FileOpenNew(gchar *Title,GtkWidget *Parent,gint X,gint Y,gboolean OpenToRead,gchar *StartPath,gchar *Mask,
                 gboolean MaskEditable,void (*CallBack)(GtkWidget *,gpointer),gboolean Persist);
void ReWriteMakeRow(gint i);
void GetRunName(gchar *FileName,gchar *RunName);
void OpenRootFile(gchar *FName,gint NPar,gchar [][MAX_TEXT_FIELD],gchar *TreeNam);
void OpenRootFileDouble(gchar *FName,gint NPar,gchar [][MAX_TEXT_FIELD],gchar *TreeNam);
void WriteRootBlock(gushort *OutBuf,gint NEvt,gint NPar);
void WriteRootBlockDouble(gushort *OutBuf,gint NEvt,gint NPar);
void CloseRootFile(void); void CloseRootFileForAnalysis(void);
int OpenRootFileForAnalysis(char *FName,int NPar);
int ReadRootBlockForReWrite(int BufNo,int NPar,int *Chan,long *EvtsRead,int *NewEvts,float *FracRead,
    int NTot,int *Select,unsigned short *OutBuf);

//External Global variables
extern struct Setup Setup;
extern enum ProgramState ProgramState;
extern enum ReWriteRequest ReWriteRequest;
extern GtkWidget *S_Stat[15];
extern struct FileSelectType *FileX;
extern gboolean UtilBusy;                //Flag indicating that Utilities is in use. Prevents running multiple utilities
extern gint TopOfset;                                         //Accounts for space occupied by window manager at the top
extern gchar ListFDir[MAX_DIR_STRLEN];                                                                  //Directory pref
extern gint TopSpace;

//Global variables within this file only
gint TheRow;                                                                           //Selected row while adding files
struct ReWrt {GtkWidget *Win; GtkWidget *Table; GtkWidget *ScrlW;};
struct ReWrt *ReWrt;                                                        //Global structure to be destroyed after use
struct Progress {GtkWidget *W; GtkWidget *PBar1; GtkWidget *PBar2; gint Timer; gfloat F1; gfloat F2; GtkWidget *Btn;};
struct Progress *Progress;                                                  //Global structure to be destroyed after use
GtkWidget **MulCheckBut;                                                     //Set of Check Buttons to select parameters
GtkWidget *InpFmtCombo,*OutFmtCombo,*DatTypCombo;

//Function templates and global variables for threads
void *g_p(gpointer Data);
//----------------------------------------------------------------------------------------------------------------------
gint ProgressTimeout(gpointer Unused)
{ 
gfloat Old1,Old2;

Old1=gtk_progress_get_value(GTK_PROGRESS(Progress->PBar1));
if (Progress->F1 > Old1) gtk_progress_set_value(GTK_PROGRESS(Progress->PBar1),Progress->F1); 
Old2=gtk_progress_get_value(GTK_PROGRESS(Progress->PBar2));
if (Progress->F2 != Old2) gtk_progress_set_value(GTK_PROGRESS(Progress->PBar2),Progress->F2); 
return TRUE;
}
//----------------------------------------------------------------------------------------------------------------------
void StopReWrite(GtkWidget *W,gpointer Unused)
{ 
ReWriteRequest=StopAllReWrite;
gtk_timeout_remove(Progress->Timer); Progress->Timer=0;
gtk_widget_destroy(GTK_WIDGET(Progress->W));
}
//----------------------------------------------------------------------------------------------------------------------
void DestroyProgress(GtkWidget *W,gpointer Unused)
{ g_free(Progress); ProgramState=Free; }
//----------------------------------------------------------------------------------------------------------------------
gint DeleteProgress(GtkWidget *W,gpointer Unused)                       //Prevents using the window x (top-right) button
{ return TRUE; }
//----------------------------------------------------------------------------------------------------------------------
void *ReWriteFile(gpointer Data)
{
gint BRead,NewEvts;
gchar Str[4096],FName[MAX_FNAME_LENGTH],NSC_txt[256],RunName[MAX_FNAME_LENGTH];
glong FSize,ZBufs,BytsRead,EvtsRead,EvtsReWritten;
gfloat FracRead;
struct stat StatBuf;
FILE *ListFile,*OutpFile;
gint FileNo,I,SkipStatus,i,BSkip;
gushort Buf[MAX_BUFSIZ],OutBuf[MAX_DATABUF];  //MAX_DATABUF in lamps.h must allow storage of the new uncompressed buffer
                                                                       //holding the parameters that are to be rewritten
struct timeval Tv;
gdouble StartTime;
gboolean DoClose,Failure;
char ParName[MAX_PAR][MAX_TEXT_FIELD];

bstart_();                                                                          //Call SUBROUTINE BSTART (in user.F)
for (FileNo=0,Progress->F1=0.0;FileNo<Setup.ReWrite.NFiles;++FileNo)
    {
    sprintf(Str,"Read %d of %d",FileNo+1,Setup.ReWrite.NFiles);
    gdk_threads_enter(); gtk_label_set_text(GTK_LABEL(S_Stat[0]),Str); gdk_threads_leave();
    GetRunName(Setup.ReWrite.ListFName[FileNo],RunName);
    fstart_(RunName,strlen(RunName)); 
    BRead=atoi(Setup.ReWrite.BufRead[FileNo]);
    if (BRead<=0) BRead=-1;                             //If BufRead is "All" or any non-numeric string read all buffers
    AbbreviateFileName(FName,Setup.ReWrite.ListFName[FileNo],18); ZBufs=0;
    stat(Setup.ReWrite.ListFName[FileNo],&StatBuf); FSize=StatBuf.st_size;
    sprintf(Str,"File Bytes: %ld",FSize);
    gdk_threads_enter(); gtk_label_set_text(GTK_LABEL(S_Stat[12]),Str); gdk_threads_leave();
    Failure=FALSE;
    switch (Setup.ReWrite.InpFormat)                                                                 //Open file to read
       {
       case 'L': case 'C': case 'c':
          if (!(ListFile=fopen(Setup.ReWrite.ListFName[FileNo],"r")))
             {
             sprintf(Str,"ERROR: Cant open %s",Setup.ReWrite.ListFName[FileNo]);
             SAttention(Str); Failure=TRUE;
             }
          break;
       case 'r':
          if (!(OpenRootFileForAnalysis(Setup.ReWrite.ListFName[FileNo],Setup.Parameter.NPar)))
             {
             sprintf(Str,"ERROR: Cant open %s, or leaf names incorrect in Root Setup",Setup.ReWrite.ListFName[FileNo]);
             Failure=TRUE;
             }
       }
    if (Failure) break;
    if (strcasecmp(Setup.ReWrite.OutFName[FileNo],"continue"))               //Open a new file if its not a continuation
       {
       Failure=FALSE;
       switch (Setup.ReWrite.OutFormat)                                                               //Open output file
          {
          case 'L': case 'C': case 'R': case 'c':                                 //zls, Candle, csv and Radware formats
          if (!(OutpFile=fopen(Setup.ReWrite.OutFName[FileNo],"w")))
             { sprintf(Str,"Cant open %s",Setup.ReWrite.OutFName[FileNo]); SAttention(Str); Failure=TRUE; }
             break;
          case 'r':                                                                                 //root output format
          for (i=0;i<Setup.Parameter.NPar;++i) strcpy(ParName[i],Setup.Parameter.Name[i]);
          switch (Setup.ReWrite.DataType)
             {
             case 'u': OpenRootFile(Setup.ReWrite.OutFName[FileNo],Setup.Parameter.NPar,ParName,Setup.ReWrite.TreeNam);
                       break;
              case 'd':OpenRootFileDouble(Setup.ReWrite.OutFName[FileNo],Setup.Parameter.NPar,ParName,
                                          Setup.ReWrite.TreeNam);
              }             
          }
       if (Failure) continue;
       switch (Setup.ReWrite.OutFormat)                                                                  //Write headers
          {
          case 'C':                                                                                      //Candle header
             sprintf(NSC_txt,"%s\n %s\n %s\n","LAMPS","Rewritten","Candle Compatible File");
             queue_text(user,NSC_txt,OutpFile); writeNames(Setup.ReWrite.NPar,0,0,OutpFile);
             sprintf(NSC_txt,"START : %s started. Run #%04d\n","rewritten",111); queue_text(start,NSC_txt,OutpFile);
             break;
          case 'R': RadwareWriteHeader(OutpFile);                                                       //Radware header
          }       
       }
    gettimeofday(&Tv,NULL); StartTime=(double)Tv.tv_sec+(double)Tv.tv_usec*1.0e-06;                        //Start timer
    for (I=0,SkipStatus=0;I<Setup.ReWrite.BufSkip[FileNo];++I)                                            //Skip Buffers
        {
        switch (Setup.ReWrite.InpFormat)
           {
           case 'C': while ((SkipStatus=FreedomSkip(ListFile))==2); break;                        //Freedom format files
           case 'L': SkipStatus=ZlsGlsSkip(ListFile);                                          //Zls or Gls format files
           case 'r': BSkip=Setup.ReWrite.BufSkip[FileNo];               //ROOT files (We will skip during ReadRootBlock)
           }
        if (SkipStatus==1) break;                                                             //Invalid Signature or EOF
        }
    ZBufs=0; BytsRead=0; EvtsRead=0; EvtsReWritten=0;
    while (TRUE)                                                                                          //Read Buffers
       {
       if (ReWriteRequest==StopAllReWrite) { Update(StartTime,FName,FSize,ZBufs,BytsRead,EvtsRead); break; }
       if (!(ZBufs%100)) Update(StartTime,FName,FSize,ZBufs,BytsRead,EvtsRead);
       switch (Setup.ReWrite.InpFormat)
          {
          case 'C': Failure=FreedomRead(ListFile,&ZBufs,&EvtsRead,&BytsRead,TRUE,OutBuf,&NewEvts); break;
          case 'L': Failure=ZlsGlsRead(ListFile,Buf,&ZBufs,&EvtsRead,&BytsRead,TRUE,OutBuf,&NewEvts); break;
          case 'c': Failure=CSVRead(ListFile,Buf,&ZBufs,&EvtsRead,&BytsRead,TRUE,OutBuf,&NewEvts); break;
          case 'r': Failure=ReadRootBlockForReWrite(BSkip+ZBufs,Setup.Parameter.NPar,Setup.Parameter.Chan,
                            &EvtsRead,&NewEvts,&FracRead,NTOT,Setup.ReWrite.Select,OutBuf);
                    ++ZBufs; FracRead=MIN(1.0,FracRead); BytsRead+=FracRead*FSize;
          }
       if (Failure) break;
       if (NewEvts>0)                              //04-03-08: Important as IUAC data has blocks other than event blocks
          {
          if (Setup.ReWrite.OutFormat=='L')                                            //L=Lamps....Output in zls format
             { if (ZlsWrite(OutpFile,OutBuf,NewEvts,Setup.ReWrite.NPar)) break; }
          else if (Setup.ReWrite.OutFormat=='C')                                   //C=Candle....Output in Candle format
             { if (!writeEventBlock(Setup.ReWrite.NPar,NewEvts,OutBuf,OutpFile)) break; }
          else if (Setup.ReWrite.OutFormat=='c')                                          //c=csv...Output in csv format
             { if (CSVWrite(OutpFile,OutBuf,NewEvts,Setup.ReWrite.NPar)) break; }
          else if (Setup.ReWrite.OutFormat=='R')                                  //R=Radware...Output in Radware format
             RadwareWrite(OutpFile,OutBuf,NewEvts,Setup.ReWrite.NPar);
          else if (Setup.ReWrite.OutFormat=='r')                                        //r=root...Output in root format
             {
             switch (Setup.ReWrite.DataType)
                {
                case 'u': WriteRootBlock(OutBuf,NewEvts,Setup.ReWrite.NPar); break;
                case 'd': WriteRootBlockDouble(OutBuf,NewEvts,Setup.ReWrite.NPar);
                }
             }
          EvtsReWritten+=NewEvts;
          Progress->F2=100.0*(gfloat)BytsRead/FSize;
          }
         if ( (ZBufs==BRead) && (BRead>0) ) break;                                                       //Limit reached
       }
    if (!DoClose) if (strcasecmp(Setup.ReWrite.OutFName[FileNo+1],"continue")) DoClose=TRUE;  //next is not continuation
    if (DoClose)                                      //Close if this is the last file or next one is not a continuation
       {
       if (Setup.ReWrite.OutFormat=='C') 
          {
          sprintf(NSC_txt,"STOP: %s ends. Collected %ld events","rewritten",EvtsReWritten);
          queue_text(stop,NSC_txt,OutpFile); writeEndOfFile(OutpFile);
          }
       if (Setup.ReWrite.OutFormat=='r') CloseRootFile();                                           //root output format
       else fclose(OutpFile);                                                                        //All other formats
       }
    fstop_();                                                                        //Call SUBROUTINE FSTOP (in user.F)
    if (ReWriteRequest==StopAllReWrite) break;
    Progress->F1=100.0*(gfloat)(FileNo+1)/Setup.ReWrite.NFiles;
    }
Update(StartTime,FName,FSize,ZBufs,BytsRead,EvtsRead);                                   //Update the display at the end
bstop_();                                                                            //Call SUBROUTINE BSTOP (in user.F)
gtk_label_set_text(GTK_LABEL(GTK_BIN(Progress->Btn)->child),"Ok");  //Change text inside button
gdk_threads_enter(); gtk_label_set_text(GTK_LABEL(S_Stat[0]),"Status: Free"); gdk_threads_leave();
UtilBusy=FALSE; pthread_exit(NULL);
return NULL;
}
//----------------------------------------------------------------------------------------------------------------------
void ReWriteRowSelect(GtkWidget *W,gpointer Data)
{ TheRow=GPOINTER_TO_INT(Data); }
//----------------------------------------------------------------------------------------------------------------------
void ReWriteBufSkipChanged(GtkWidget *W,gpointer Data)
{
TheRow=GPOINTER_TO_INT(Data);
Setup.ReWrite.BufSkip[TheRow]=atoi(gtk_entry_get_text(GTK_ENTRY(W)));
}
//----------------------------------------------------------------------------------------------------------------------
void ReWriteBufReadChanged(GtkWidget *W,gpointer Data)
{
TheRow=GPOINTER_TO_INT(Data);
strcpy(Setup.ReWrite.BufRead[TheRow],gtk_entry_get_text(GTK_ENTRY(W)));
}
//----------------------------------------------------------------------------------------------------------------------
void OutFNameChanged(GtkWidget *W,gpointer Data)
{
TheRow=GPOINTER_TO_INT(Data);
strcpy(Setup.ReWrite.OutFName[TheRow],gtk_entry_get_text(GTK_ENTRY(W)));
}
//----------------------------------------------------------------------------------------------------------------------
void GenerateOutFName(gchar *OutFName)                              //Generate OutFName based on Setup.ReWrite.ListFName
{
AbbreviateFileName(OutFName,Setup.ReWrite.ListFName[TheRow],MAX_FNAME_LENGTH-1);
switch (Setup.ReWrite.OutFormat)
   {
   case 'L': strcpy(strrchr(OutFName,'.'),".zls");  break;                                                //Lamps (.zls)
   case 'C': strcpy(strrchr(OutFName,'.'),".001");  break;                                       //Candle/Freedom (.001)
   case 'R': strcpy(strrchr(OutFName,'.'),".dmp");  break;                                         //Radware dump (.dmp)
   case 'r': strcpy(strrchr(OutFName,'.'),".root"); break;                                                //root (.root)
   case 'c': strcpy(strrchr(OutFName,'.'),".csv");                                                        //Excel (.csv)
   }
}
//----------------------------------------------------------------------------------------------------------------------
void ReWriteFSelected(GtkWidget *W,gpointer Unused)                                     //Get the selected list filename
{
gint ColWidth[5]={40,200,80,80,200};
gchar Str[MAX_FNAME_LENGTH+5];
GtkWidget *But,*Entry;
gfloat End;

if (Setup.ReWrite.NFiles == MAX_REWRITE_FILES) return;                                //Limit reached. Need a popup here
Setup.ReWrite.NFiles=MIN(MAX_REWRITE_FILES,Setup.ReWrite.NFiles+1);                                   //Increment NFiles
gtk_widget_set_sensitive(InpFmtCombo,FALSE);                          //Dont allow InpFormat to be changed at this stage
gtk_widget_set_sensitive(OutFmtCombo,FALSE);                          //Dont allow OutFormat to be changed at this stage
TheRow=MAX(0,Setup.ReWrite.NFiles-1);                                                              //TheRow=selected row
if (strlen(FileX->Path)+strlen(FileX->TargetFile)+1>MAX_FNAME_LENGTH)
   { Attention(0,"ERROR: MAX_FNAME_LENGTH exceeded"); return; }
sprintf(Setup.ReWrite.ListFName[TheRow],"%s/%s",FileX->Path,FileX->TargetFile);                        //Store full path

gtk_table_resize(GTK_TABLE(ReWrt->Table),Setup.ReWrite.NFiles,5);

sprintf(Str,"%02d",TheRow+1);
But=gtk_button_new_with_label(Str);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(ReWriteRowSelect),GINT_TO_POINTER(TheRow));
gtk_widget_set_size_request(GTK_WIDGET(But),ColWidth[0],-1);
gtk_table_attach(GTK_TABLE(ReWrt->Table),But,0,1,TheRow,TheRow+1,GTK_FILL,GTK_SHRINK,0,0);

AbbreviateFileName(Str,Setup.ReWrite.ListFName[TheRow],18);
But=gtk_button_new_with_label(Str);
gtk_widget_set_size_request(GTK_WIDGET(But),ColWidth[1],-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(ReWriteRowSelect),GINT_TO_POINTER(TheRow));
gtk_table_attach(GTK_TABLE(ReWrt->Table),But,1,2,TheRow,TheRow+1,GTK_FILL,GTK_SHRINK,0,0);

Entry=gtk_entry_new_with_max_length(MAX_FNAME_LENGTH);
sprintf(Str,"%d",Setup.ReWrite.BufSkip[TheRow]); gtk_entry_set_text(GTK_ENTRY(Entry),Str);
gtk_widget_set_size_request(GTK_WIDGET(Entry),ColWidth[2],-1);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(ReWriteBufSkipChanged),GINT_TO_POINTER(TheRow));
gtk_table_attach(GTK_TABLE(ReWrt->Table),Entry,2,3,TheRow,TheRow+1,GTK_FILL,GTK_SHRINK,0,0);

Entry=gtk_entry_new_with_max_length(MAX_FNAME_LENGTH);
gtk_entry_set_text(GTK_ENTRY(Entry),Setup.ReWrite.BufRead[TheRow]);
gtk_widget_set_size_request(GTK_WIDGET(Entry),ColWidth[3],-1);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(ReWriteBufReadChanged),GINT_TO_POINTER(TheRow));
gtk_table_attach(GTK_TABLE(ReWrt->Table),Entry,3,4,TheRow,TheRow+1,GTK_FILL,GTK_SHRINK,0,0);

Entry=gtk_entry_new_with_max_length(MAX_FNAME_LENGTH);
GenerateOutFName(Setup.ReWrite.OutFName[TheRow]);
gtk_entry_set_text(GTK_ENTRY(Entry),Setup.ReWrite.OutFName[TheRow]);
gtk_widget_set_size_request(GTK_WIDGET(Entry),ColWidth[4],-1);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(OutFNameChanged),GINT_TO_POINTER(TheRow));
gtk_table_attach(GTK_TABLE(ReWrt->Table),Entry,4,5,TheRow,TheRow+1,GTK_FILL,GTK_SHRINK,0,0);

End=16.0*TheRow; if (TheRow>8) End=40.0*TheRow;                                          //Fudging to scroll to the end!
gtk_adjustment_set_value(GTK_ADJUSTMENT(gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(ReWrt->ScrlW))),End); 
gtk_widget_show_all(ReWrt->Table);
}
//----------------------------------------------------------------------------------------------------------------------
void AddReWrite(GtkWidget *W,gpointer Unused)                                            //User clicked the "Add" button
{
if (Setup.ReWrite.NFiles == MAX_OFFLINE_FILES) return;                                                   //Limit reached
FileX=g_new(struct FileSelectType,1);
switch (Setup.ReWrite.InpFormat)                                              //File selector masks depends on InpFormat
   {
   case 'C': //NSC Candle format
      FileOpenNew("Select Candle Files",ReWrt->Win,600,TopSpace,TRUE,ListFDir,".001",TRUE,&ReWriteFSelected,TRUE);
      break;
   case 'L': //zls format
      FileOpenNew("Select ZLS Files",ReWrt->Win,600,TopSpace,TRUE,ListFDir,".zls",TRUE,&ReWriteFSelected,TRUE);
      break;
   case 'r': //root format
      FileOpenNew("Select ROOT Files",ReWrt->Win,600,TopSpace,TRUE,ListFDir,".root",TRUE,&ReWriteFSelected,TRUE);
      break;
   case 'c': //csv format
      FileOpenNew("Select CSV Files",ReWrt->Win,600,TopSpace,TRUE,ListFDir,".csv",TRUE,&ReWriteFSelected,TRUE);
   }
}
//----------------------------------------------------------------------------------------------------------------------
void ClearReWrite(gpointer Unused)                                                         //User clicked "Clear" button
{
gint i;

if (TheRow>Setup.ReWrite.NFiles-1) return;
Setup.ReWrite.NFiles=MAX(0,Setup.ReWrite.NFiles-1);
for (i=TheRow;i<Setup.ReWrite.NFiles;++i)               //Move the info of rows one step up, overwriting the deleted row
    {
    strcpy(Setup.ReWrite.ListFName[i],Setup.ReWrite.ListFName[i+1]);
    Setup.ReWrite.BufSkip[i]=Setup.ReWrite.BufSkip[i+1];
    strcpy(Setup.ReWrite.BufRead[i],Setup.ReWrite.BufRead[i+1]);
    strcpy(Setup.ReWrite.OutFName[i],Setup.ReWrite.OutFName[i+1]);
    }
TheRow=MAX(0,TheRow-1);                                                                            //Move up the pointer
if (GTK_IS_WIDGET(ReWrt->Table)) gtk_widget_destroy(ReWrt->Table);

ReWrt->Table=gtk_table_new(Setup.ReWrite.NFiles,5,FALSE);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ReWrt->ScrlW),ReWrt->Table);         //Pack Table into ScrollW
for (i=0;i<Setup.ReWrite.NFiles;++i) ReWriteMakeRow(i);
gtk_widget_show_all(ReWrt->ScrlW);
if (Setup.ReWrite.NFiles==0) { gtk_widget_set_sensitive(InpFmtCombo,TRUE); gtk_widget_set_sensitive(OutFmtCombo,TRUE); }
}
//----------------------------------------------------------------------------------------------------------------------
void ClearAllReWrite(gpointer Unused)                                                   //User clicked "ClearAll" button
{
if (GTK_IS_WIDGET(ReWrt->Table)) gtk_widget_destroy(ReWrt->Table);
TheRow=0; Setup.ReWrite.NFiles=0;
ReWrt->Table=gtk_table_new(Setup.ReWrite.NFiles,5,FALSE);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ReWrt->ScrlW),ReWrt->Table);
gtk_widget_show_all(ReWrt->ScrlW);
gtk_widget_set_sensitive(InpFmtCombo,TRUE); gtk_widget_set_sensitive(OutFmtCombo,TRUE);
}
//----------------------------------------------------------------------------------------------------------------------
void CloseReWrite(GtkWidget *W,gpointer Unused)
{
g_free(ReWrt);                                                                                              //Important!
ProgramState=Free; UtilBusy=FALSE;
}
//----------------------------------------------------------------------------------------------------------------------
void CancelReWrite(GtkWidget *W,GtkWidget *ReWin)
{ UtilBusy=FALSE; gtk_widget_destroy(ReWin); }
//----------------------------------------------------------------------------------------------------------------------
void StartReWrite(GtkWidget *Button,GtkWidget *ReWin)
{
GtkWidget *VBox,*HBox,*Label,*But;
gint i;
pthread_t ReWriter;

gtk_widget_destroy(ReWin);                         //Close dialog window, this will also call CloseReWrite automatically
if (Setup.ReWrite.InpFormat=='r' && Setup.ReWrite.OutFormat=='r') 
   {
   Attention(100,"Due to ROOT limitations, cannot rewrite from root to root!\n"
                 "Please write from root to zls and then zls to root");
   UtilBusy=FALSE; return;
   }

if (!Setup.ReWrite.NFiles) { Attention(100,"No files selected for rewriting"); UtilBusy=FALSE; return; }
for (i=0,Setup.ReWrite.NPar=0;i<NTOT;++i) if (Setup.ReWrite.Select[i]) ++Setup.ReWrite.NPar;
if (!Setup.ReWrite.NPar) { Attention(-100,"No parameters selected for rewriting"); UtilBusy=FALSE; return; }
ReWriteRequest=NormalReWrite;
ProgramState=ReWriteOn;

//Create window with progress bar
Progress=g_new(struct Progress,1); 
Progress->W=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_widget_set_uposition(Progress->W,400,294);
gtk_window_set_title(GTK_WINDOW(Progress->W),"Rewriting Progress");
gtk_window_set_policy(GTK_WINDOW(Progress->W),FALSE,FALSE,TRUE);
g_signal_connect(GTK_OBJECT(Progress->W),"delete_event",G_CALLBACK(DeleteProgress),NULL);
g_signal_connect(GTK_OBJECT(Progress->W),"destroy",G_CALLBACK(DestroyProgress),NULL);

VBox=gtk_vbox_new(FALSE,5);
gtk_container_set_border_width(GTK_CONTAINER(VBox),10);
gtk_container_add(GTK_CONTAINER(Progress->W),VBox);

HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Label=gtk_label_new("Files Done:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
Progress->PBar1=gtk_progress_bar_new();
gtk_progress_set_format_string(GTK_PROGRESS(Progress->PBar1),"%v%%");
gtk_progress_set_show_text(GTK_PROGRESS(Progress->PBar1),TRUE);
gtk_box_pack_start(GTK_BOX(HBox),Progress->PBar1,FALSE,FALSE,0);

HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Label=gtk_label_new("This File:"); gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,7);
Progress->PBar2=gtk_progress_bar_new();
gtk_progress_set_format_string(GTK_PROGRESS(Progress->PBar2),"%v%%");
gtk_progress_set_show_text(GTK_PROGRESS(Progress->PBar2),TRUE);
gtk_box_pack_start(GTK_BOX(HBox),Progress->PBar2,FALSE,FALSE,0);

Progress->Timer=gtk_timeout_add(100,ProgressTimeout,NULL);

HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,10);
Progress->Btn=gtk_button_new_with_label("Halt Rewrite");
gtk_box_pack_start(GTK_BOX(HBox),Progress->Btn,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(Progress->Btn),"clicked",G_CALLBACK(StopReWrite),NULL);
gtk_widget_show_all(Progress->W);
//End of progress bar stuff

pthread_create(&ReWriter,NULL,ReWriteFile,NULL);                                                          //Start thread
}
//----------------------------------------------------------------------------------------------------------------------
void ReWriteMakeRow(gint i)
{
gint ColWidth[5]={40,200,80,80,200};
GtkWidget *But,*Entry;
gchar Str[MAX_FNAME_LENGTH+10];

sprintf(Str,"%02d",i+1); But=gtk_button_new_with_label(Str); 
gtk_widget_set_size_request(GTK_WIDGET(But),ColWidth[0],-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(ReWriteRowSelect),GINT_TO_POINTER(i));
gtk_table_attach(GTK_TABLE(ReWrt->Table),But,0,1,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

AbbreviateFileName(Str,Setup.ReWrite.ListFName[i],18);
But=gtk_button_new_with_label(Str); 
gtk_widget_set_size_request(GTK_WIDGET(But),ColWidth[1],-1);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(ReWriteRowSelect),GINT_TO_POINTER(i));
gtk_table_attach(GTK_TABLE(ReWrt->Table),But,1,2,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

Entry=gtk_entry_new_with_max_length(MAX_FNAME_LENGTH);
sprintf(Str,"%d",Setup.ReWrite.BufSkip[i]); gtk_entry_set_text(GTK_ENTRY(Entry),Str);
gtk_widget_set_size_request(GTK_WIDGET(Entry),ColWidth[2],-1);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(ReWriteBufSkipChanged),GINT_TO_POINTER(i));
gtk_table_attach(GTK_TABLE(ReWrt->Table),Entry,2,3,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

Entry=gtk_entry_new_with_max_length(MAX_FNAME_LENGTH);
gtk_entry_set_text(GTK_ENTRY(Entry),Setup.ReWrite.BufRead[i]);
gtk_widget_set_size_request(GTK_WIDGET(Entry),ColWidth[3],-1);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(ReWriteBufReadChanged),GINT_TO_POINTER(i));
gtk_table_attach(GTK_TABLE(ReWrt->Table),Entry,3,4,i,i+1,GTK_FILL,GTK_SHRINK,0,0);

Entry=gtk_entry_new_with_max_length(MAX_FNAME_LENGTH);
gtk_entry_set_text(GTK_ENTRY(Entry),Setup.ReWrite.OutFName[i]);
gtk_widget_set_size_request(GTK_WIDGET(Entry),ColWidth[4],-1);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(OutFNameChanged),GINT_TO_POINTER(i));
gtk_table_attach(GTK_TABLE(ReWrt->Table),Entry,4,5,i,i+1,GTK_FILL,GTK_SHRINK,0,0);
}
//----------------------------------------------------------------------------------------------------------------------
void InputFormatCallBack(GtkWidget *W,gpointer Unused)
{
gchar Temp[4];

strncpy(Temp,gtk_entry_get_text(GTK_ENTRY(W)),1);
Setup.ReWrite.InpFormat=Temp[0];                       //InpFormat='L':Lamps zls, 'C':Candle/Freedom, 'r':root, 'c': csv
}
//----------------------------------------------------------------------------------------------------------------------
void OutputFormatCallBack(GtkWidget *W,gpointer Unused)
{
gchar Temp[4];

strncpy(Temp,gtk_entry_get_text(GTK_ENTRY(W)),1);
Setup.ReWrite.OutFormat=Temp[0]; //Setup.ReWrite.OutFormat='L':Lamps zls,'C':Candle/Freedom,'R':Radware,'r':root,'c':csv
}
//----------------------------------------------------------------------------------------------------------------------
void DatTypCallBack(GtkWidget *W,gpointer Unused)
{
gchar Temp[4];

strncpy(Temp,gtk_entry_get_text(GTK_ENTRY(W)),1);
Setup.ReWrite.DataType=Temp[0];                                     //Setup.ReWrite.DatTye='u':unsigned short,'d':double
}
//----------------------------------------------------------------------------------------------------------------------
void SelectAll(GtkWidget *W,gpointer Data)
{
int i;

for (i=0;i<NTOT;++i)
    {
    Setup.ReWrite.Select[i]=TRUE;
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(MulCheckBut[i]),TRUE);
    }
}
//----------------------------------------------------------------------------------------------------------------------
void DeSelectAll(GtkWidget *W,gpointer Data)
{
int i;

for (i=0;i<NTOT;++i)
    {
    Setup.ReWrite.Select[i]=FALSE;
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(MulCheckBut[i]),FALSE);
    }
}
//----------------------------------------------------------------------------------------------------------------------
void ReWriteSelect(GtkWidget *W,gpointer Data)
{
if (GTK_TOGGLE_BUTTON(W)->active) Setup.ReWrite.Select[GPOINTER_TO_INT(Data)]=TRUE;
else                              Setup.ReWrite.Select[GPOINTER_TO_INT(Data)]=FALSE;
}
//----------------------------------------------------------------------------------------------------------------------
void SelectParamsDone(GtkWidget *W,gpointer Data)
{
g_free(MulCheckBut);
}
//----------------------------------------------------------------------------------------------------------------------
void SelectParams(GtkWidget *W,gpointer Data)
{
GtkStyle *Style;
const GdkColor BlueC   = {0,0x0000,0x0000,0x5555};
const GdkColor WhiteC  = {0,0xFFFF,0xFFFF,0xFFFF};
GtkWidget *Win,*HBox,*VBox,*Table,*But,*ScrollW;
gint i;
gchar Str[20];

MulCheckBut=g_new(GtkWidget *,NTOT);                                            //Check buttons for selecting parameters

Style=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { Style->fg[i]=Style->text[i]=WhiteC; Style->bg[i]=BlueC; }

Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_title(GTK_WINDOW(Win),"Select Parameters");
gtk_widget_set_uposition(GTK_WIDGET(Win),58,TopSpace+TopOfset);
gtk_widget_set_size_request(GTK_WIDGET(Win),-1,600);
g_signal_connect(GTK_OBJECT(Win),"destroy",G_CALLBACK(SelectParamsDone),NULL);

VBox=gtk_vbox_new(FALSE,0); gtk_container_add(GTK_CONTAINER(Win),VBox);
gtk_container_set_border_width(GTK_CONTAINER(VBox),5);

HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
But=gtk_button_new_with_label("Para#"); SetStyleRecursively(But,Style); gtk_widget_set_size_request(But,56,-1);
gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);
But=gtk_button_new_with_label("Name"); SetStyleRecursively(But,Style); gtk_widget_set_size_request(But,240,-1);
gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);
But=gtk_button_new_with_label("Write"); SetStyleRecursively(But,Style); gtk_widget_set_size_request(But,54,-1);
gtk_box_pack_start(GTK_BOX(HBox),But,FALSE,FALSE,0);

ScrollW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollW),GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
gtk_box_pack_start(GTK_BOX(VBox),ScrollW,TRUE,TRUE,0);
Table=gtk_table_new(NTOT,3,FALSE);
gtk_table_set_row_spacings(GTK_TABLE(Table),1); gtk_table_set_col_spacings(GTK_TABLE(Table),5);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ScrollW),Table);

for (i=0;i<NTOT;++i)
    {
    sprintf(Str,"%3d",i+1); But=gtk_button_new_with_label(Str);
    gtk_widget_set_size_request(But,56,-1);
    gtk_table_attach(GTK_TABLE(Table),But,0,1,i,i+1,GTK_FILL,GTK_SHRINK,0,0);
    if (i<Setup.Parameter.NPar) But=gtk_button_new_with_label(Setup.Parameter.Name[i]); 
    else But=gtk_button_new_with_label(Setup.Pseudo.Name[i-Setup.Parameter.NPar]);
    gtk_widget_set_size_request(But,240,-1);
    gtk_table_attach(GTK_TABLE(Table),But,1,2,i,i+1,GTK_FILL,GTK_SHRINK,0,0);
    MulCheckBut[i]=gtk_check_button_new(); gtk_widget_set_size_request(GTK_WIDGET(MulCheckBut[i]),20,-1);
    gtk_table_attach(GTK_TABLE(Table),MulCheckBut[i],2,3,i,i+1,GTK_FILL,GTK_SHRINK,0,0);
    if (Setup.ReWrite.Select[i]) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(MulCheckBut[i]),TRUE);
    g_signal_connect(GTK_OBJECT(MulCheckBut[i]),"toggled",G_CALLBACK(ReWriteSelect),GINT_TO_POINTER(i));
    }

HBox=gtk_hbox_new(FALSE,5); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,5);
But=gtk_button_new_with_label("Select\n   All"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(SelectAll),NULL);
But=gtk_button_new_with_label("DeSelect\n     All"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(DeSelectAll),NULL);
But=gtk_button_new_with_label("Okay"); gtk_box_pack_start(GTK_BOX(HBox),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(gtk_widget_destroy),GTK_OBJECT(Win));

gtk_widget_show_all(Win);
}
//----------------------------------------------------------------------------------------------------------------------
void TreeNamChanged(GtkWidget *W,gpointer Unused)
{ snprintf(Setup.ReWrite.TreeNam,MAX_TEXT_FIELD,"%s",gtk_entry_get_text(GTK_ENTRY(W))); }
//----------------------------------------------------------------------------------------------------------------------
void ReWriteSetup(GtkWidget *W,gpointer Data)
{
static gchar *Titles[5]= {"No\n","List File\nName","Buffs to\nSkip","Buffs to\nRead","Out File\nor continue"};
gint ColWidth[5]={40,200,80,80,200};
static GdkColor TitlesBg  = {0,0x7777,0x0000,0x7777};
static GdkColor TitlesFg  = {0,0xFFFF,0xFFFF,0xFFFF};
static GdkColor RedBg  = {0,0xFFFF,0x5555,0x5555};
static GdkColor RedFg  = {0,0xFFFF,0xFFFF,0xFFFF};
static GdkColor Red =   {0,0xffff,0x0000,0x0000};
static GdkColor Blue =  {0,0x0000,0x0000,0xffff};
static GdkColor Green = {0,0x0000,0xaaaa,0x0000};
GtkStyle *TitlesStyle,*RedStyle,*LStyle;
GtkWidget *VBox,*VBox1,*VBox2,*HBox,*HBox1,*HBox2,*Table,*TitlesBut,*But,*Label,*Text,*Entry,*Sep;
GList *GList;
GdkFont *Fnt;
gint i;

if (ProgramState != Free) { Attention(0,"Another task is in progress"); return; }
if (UtilBusy)  { Attention(0,"Another utility is already running"); return; }
UtilBusy=TRUE;
ReWrt=g_new(struct ReWrt,1);                                                      //Allocate memory, must be freed later

TitlesStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { TitlesStyle->fg[i]=TitlesStyle->text[i]=TitlesFg; TitlesStyle->bg[i]=TitlesBg; }
RedStyle=gtk_style_copy(gtk_widget_get_default_style());
for (i=0;i<5;i++) { RedStyle->fg[i]=RedStyle->text[i]=RedFg; RedStyle->bg[i]=RedBg; }
LStyle=gtk_style_copy(gtk_widget_get_default_style()); for (i=0;i<5;i++) LStyle->fg[i]=Red;

Fnt=gdk_font_load("-misc-fixed-medium-r-*-*-*-140-*-*-*-*-*-*");

ReWrt->Win=gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_title(GTK_WINDOW(ReWrt->Win),"Rewrite Files");
g_signal_connect(GTK_OBJECT(ReWrt->Win),"destroy",G_CALLBACK(CloseReWrite),NULL);

VBox=gtk_vbox_new(FALSE,12); gtk_container_add(GTK_CONTAINER(ReWrt->Win),VBox); 
gtk_container_set_border_width(GTK_CONTAINER(VBox),5);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,FALSE,FALSE,0);
Text=gtk_text_new(NULL,NULL); gtk_widget_set_size_request(GTK_WIDGET(Text),650,260);
gtk_text_set_editable(GTK_TEXT(Text),FALSE); gtk_text_set_word_wrap(GTK_TEXT(Text),TRUE);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Red,NULL,"      For more info see Help/Contents/Utilities/ReWrite List File\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"1. Edit user.F for user defined pseudos. ",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"Events to be filtered should have all relevant paras and pseudos ",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"set to zero in user.F\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"2. Prepare a Setup or Root Setup that can read the file(s)\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"3. Select parameters (and pseudos) to be written to output\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"4. Select Input and Output formats BEFORE adding files\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"5. If Output Format is root set TreeName and Data Type\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Green,NULL,"e.g. LampsTree and unsigned short or RoseNIAS and double\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"6. Click Add for all the required files\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"7. Change output file names as required\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Green,NULL,"or enter continue to combine with previous file\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Blue,NULL,"8. Click Start Rewrite\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Red,NULL,"Note: Output directory is lamps and not lamps/zls\n\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Green,NULL,"Due to ROOT limitations you cannot rewrite from root to root\n",-1);
gtk_text_insert(GTK_TEXT(Text),Fnt,&Green,NULL,"Instead write from root to zls and then from zls to root",-1);

gtk_box_pack_start(GTK_BOX(HBox),Text,FALSE,FALSE,0);

VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,FALSE,0);
But=gtk_button_new_with_label("    Select\nParameters"); gtk_box_pack_start(GTK_BOX(VBox1),But,TRUE,FALSE,20);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(SelectParams),NULL);

HBox2=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox2,FALSE,FALSE,0);

Label=gtk_label_new("Input Format:"); gtk_box_pack_start(GTK_BOX(HBox2),Label,FALSE,FALSE,0);
InpFmtCombo=gtk_combo_new();
GList=NULL; GList=g_list_append(GList,"Lamps zls");
GList=g_list_append(GList,"Candle"); GList=g_list_append(GList,"root"); GList=g_list_append(GList,"csv");
gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(InpFmtCombo)->entry),FALSE);
gtk_combo_set_popdown_strings(GTK_COMBO(InpFmtCombo),GList);
switch (Setup.ReWrite.InpFormat)
   {
   case 'L': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(InpFmtCombo)->entry),"Lamps zls"); break;
   case 'C': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(InpFmtCombo)->entry),"Candle"); break;
   case 'r': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(InpFmtCombo)->entry),"root"); break;
   case 'c': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(InpFmtCombo)->entry),"csv");
   }
g_signal_connect(GTK_OBJECT(GTK_COMBO(InpFmtCombo)->entry),"changed",G_CALLBACK(InputFormatCallBack),NULL);
gtk_box_pack_start(GTK_BOX(HBox2),InpFmtCombo,FALSE,FALSE,0);
gtk_widget_set_sensitive(InpFmtCombo,TRUE);

Label=gtk_label_new("          Output Format:"); gtk_box_pack_start(GTK_BOX(HBox2),Label,FALSE,FALSE,0);
OutFmtCombo=gtk_combo_new();
GList=NULL; GList=g_list_append(GList,"Lamps zls"); GList=g_list_append(GList,"Candle");
GList=g_list_append(GList,"Radware Dump"); GList=g_list_append(GList,"root"); GList=g_list_append(GList,"csv");
gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(OutFmtCombo)->entry),FALSE);
gtk_combo_set_popdown_strings(GTK_COMBO(OutFmtCombo),GList);
switch (Setup.ReWrite.OutFormat)
   {
   case 'L': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(OutFmtCombo)->entry),"Lamps zls"); break;
   case 'C': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(OutFmtCombo)->entry),"Candle"); break;
   case 'r': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(OutFmtCombo)->entry),"root"); break;
   case 'c': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(OutFmtCombo)->entry),"csv");
   }
g_signal_connect(GTK_OBJECT(GTK_COMBO(OutFmtCombo)->entry),"changed",G_CALLBACK(OutputFormatCallBack),NULL);
gtk_box_pack_start(GTK_BOX(HBox2),OutFmtCombo,FALSE,FALSE,0);
gtk_widget_set_sensitive(OutFmtCombo,TRUE);

Sep=gtk_hseparator_new(); SetStyleRecursively(Sep,RedStyle); gtk_box_pack_start(GTK_BOX(VBox),Sep,FALSE,TRUE,0);
Label=gtk_label_new("Tree Name and Data Type are relevant only if Output Format is root"); SetStyleRecursively(Label,LStyle);
gtk_box_pack_start(GTK_BOX(VBox),Label,FALSE,FALSE,0);
HBox2=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox2,FALSE,FALSE,0);
Label=gtk_label_new("Tree Name:"); SetStyleRecursively(Label,LStyle);
gtk_box_pack_start(GTK_BOX(HBox2),Label,FALSE,FALSE,0);
Entry=gtk_entry_new_with_max_length(MAX_TEXT_FIELD);
gtk_entry_set_text(GTK_ENTRY(Entry),Setup.ReWrite.TreeNam);
gtk_widget_set_size_request(GTK_WIDGET(Entry),120,-1);
gtk_box_pack_start(GTK_BOX(HBox2),Entry,FALSE,FALSE,0);
g_signal_connect(GTK_OBJECT(Entry),"changed",G_CALLBACK(TreeNamChanged),NULL);
Label=gtk_label_new("                   Data Type:"); SetStyleRecursively(Label,LStyle);
gtk_box_pack_start(GTK_BOX(HBox2),Label,FALSE,FALSE,0);
DatTypCombo=gtk_combo_new();
GList=NULL; GList=g_list_append(GList,"unsigned short"); GList=g_list_append(GList,"double");
gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(DatTypCombo)->entry),FALSE);
gtk_combo_set_popdown_strings(GTK_COMBO(DatTypCombo),GList);
switch (Setup.ReWrite.DataType)
   {
   case 'u': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(DatTypCombo)->entry),"unsigned short"); break;
   case 'd': gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(DatTypCombo)->entry),"double");
   }
g_signal_connect(GTK_OBJECT(GTK_COMBO(DatTypCombo)->entry),"changed",G_CALLBACK(DatTypCallBack),NULL);
gtk_box_pack_start(GTK_BOX(HBox2),DatTypCombo,FALSE,FALSE,0);
Sep=gtk_hseparator_new(); SetStyleRecursively(Sep,RedStyle); gtk_box_pack_start(GTK_BOX(VBox),Sep,FALSE,TRUE,0);

HBox=gtk_hbox_new(FALSE,10); gtk_box_pack_start(GTK_BOX(VBox),HBox,TRUE,TRUE,0);
VBox1=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox1,TRUE,TRUE,0); 
Table=gtk_table_new(1,5,FALSE);
for (i=0;i<5;++i)
    {
    TitlesBut=gtk_button_new_with_label(Titles[i]); SetStyleRecursively(TitlesBut,TitlesStyle);
    gtk_widget_set_size_request(GTK_WIDGET(TitlesBut),ColWidth[i],-1);
    gtk_table_attach(GTK_TABLE(Table),TitlesBut,i,i+1,0,1,GTK_FILL,GTK_SHRINK,0,0);
    }
gtk_box_pack_start(GTK_BOX(VBox1),Table,FALSE,FALSE,2);

ReWrt->ScrlW=gtk_scrolled_window_new(NULL,NULL);
gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ReWrt->ScrlW),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
gtk_widget_set_size_request(GTK_WIDGET(ReWrt->ScrlW),-1,200);
gtk_box_pack_start(GTK_BOX(VBox1),ReWrt->ScrlW,TRUE,TRUE,0);

ReWrt->Table=gtk_table_new(Setup.ReWrite.NFiles,5,FALSE);
gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ReWrt->ScrlW),ReWrt->Table);
for (i=0;i<Setup.ReWrite.NFiles;++i) ReWriteMakeRow(i);

VBox2=gtk_vbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(HBox),VBox2,FALSE,FALSE,0);
But=gtk_button_new_with_label("Add"); gtk_box_pack_start(GTK_BOX(VBox2),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(AddReWrite),NULL);
But=gtk_button_new_with_label("Clear"); gtk_box_pack_start(GTK_BOX(VBox2),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(ClearReWrite),NULL);
But=gtk_button_new_with_label("Clear All"); gtk_box_pack_start(GTK_BOX(VBox2),But,TRUE,FALSE,0);
g_signal_connect_swapped(GTK_OBJECT(But),"clicked",G_CALLBACK(ClearAllReWrite),NULL);

HBox1=gtk_hbox_new(FALSE,0); gtk_box_pack_start(GTK_BOX(VBox),HBox1,FALSE,FALSE,0);
But=gtk_button_new_with_label("Start Rewrite"); gtk_box_pack_start(GTK_BOX(HBox1),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(StartReWrite),ReWrt->Win);
But=gtk_button_new_with_label("Cancel"); gtk_box_pack_start(GTK_BOX(HBox1),But,TRUE,FALSE,0);
g_signal_connect(GTK_OBJECT(But),"clicked",G_CALLBACK(CancelReWrite),ReWrt->Win);

gtk_widget_show_all(ReWrt->Win);                                                    //Show all the widgets in the window
gtk_style_unref(TitlesStyle);
g_list_free(GList);
}
//----------------------------------------------------------------------------------------------------------------------

