#include <gtk/gtk.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include "lamps.h"
//Needs a 2 parameter setup each with 4095 resolution. If NPar>2 we put the same data in odd-even positions
//The basic data below can be changed as required
#define CENTRE0 1500.0                                                                 //Centre of the Gaussian for P[0]
#define CENTRE1 2500.0                                                                 //Centre of the Gaussian for P[1]
#define FWHM0 450.0                                                                     //Width of the Gaussian for P[0]
#define FWHM1 350.0                                                                     //Width of the Gaussian for P[1]

extern struct Setup Setup;
//----------------------------------------------------------------------------------------------------------------------
void BoxMuller(double *R1,double *R2)
//Gives 2 independent gauss-random numbers R1 and R2 mean=0, sigma=1 by Box-Muller transformation
{
double U1,U2,R;

U1=(double)rand()/RAND_MAX; U2=(double)rand()/RAND_MAX;
R=sqrt(-2.0*log(U1));
*R1=R*cos(2.0*M_PI*U2);
*R2=R*sin(2.0*M_PI*U2);
}
//----------------------------------------------------------------------------------------------------------------------
unsigned short Clamp(double Value,unsigned short Lo,unsigned short Hi)
{
unsigned short Val;

Val=(unsigned short)(Value+0.5);
if (Val<Lo) return Lo;
if (Val>Hi) return Hi;
return Val;
}
//----------------------------------------------------------------------------------------------------------------------
int SimulateRead(gushort *AcqBuf,guint32 *ScalerBuf)
{
gint i,j,k,NEvts;
gdouble R1,R2,x,y;
unsigned short P[2];

for(i=0;i<65535;++i) AcqBuf[i]=0;
NEvts=Setup.ListMode.BufSiz/2/Setup.Parameter.NPar;

for (i=0;i<NEvts;++i)
   {
   BoxMuller(&R1,&R2);
   x=R1*FWHM0/2.355+CENTRE0; y=R2*FWHM1/2.355+CENTRE1;
   P[0]=Clamp(x,0,4095); P[1]=Clamp(y,0,4095);
   for (j=0;j<Setup.Parameter.NPar;++j)
      {
      k=i*Setup.Parameter.NPar+j;
      if (!(k%2)) AcqBuf[k]=P[0]; else AcqBuf[k]=P[1];
      }
   }
sleep(1);                                                                            //To slow down. Adjust as required.
return 2*NEvts*Setup.Parameter.NPar;
}
//----------------------------------------------------------------------------------------------------------------------
